/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.graph.UnmodifiableGraph;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.web.DatasetGraphAccessor;
import org.apache.jena.web.HttpSC;
import org.apache.jena.web.JenaHttpException;
import org.apache.jena.web.JenaHttpNotFoundException;

public class DatasetGraphAccessorHTTP
implements DatasetGraphAccessor {
    private final String remote;
    private static HttpParams httpParams = DatasetGraphAccessorHTTP.createHttpParams();

    public DatasetGraphAccessorHTTP(String remote) {
        this.remote = remote;
    }

    @Override
    public Graph httpGet() {
        return this.doGet(this.targetDefault());
    }

    @Override
    public Graph httpGet(Node graphName) {
        return this.doGet(this.target(graphName));
    }

    private Graph doGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        try {
            return this.exec(url, null, httpGet, true);
        }
        catch (JenaHttpNotFoundException ex) {
            return null;
        }
    }

    @Override
    public boolean httpHead() {
        return this.doHead(this.targetDefault());
    }

    @Override
    public boolean httpHead(Node graphName) {
        return this.doHead(this.target(graphName));
    }

    private boolean doHead(String url) {
        HttpHead httpHead = new HttpHead(url);
        try {
            this.exec(url, null, httpHead, false);
            return true;
        }
        catch (JenaHttpException ex) {
            if (ex.getStatusCode() == 404) {
                return false;
            }
            throw ex;
        }
    }

    @Override
    public void httpPut(Graph data) {
        this.doPut(this.targetDefault(), data);
    }

    @Override
    public void httpPut(Node graphName, Graph data) {
        this.doPut(this.target(graphName), data);
    }

    private void doPut(String url, Graph data) {
        HttpPut httpPut = new HttpPut(url);
        this.exec(url, data, httpPut, false);
    }

    @Override
    public void httpDelete() {
        this.doDelete(this.targetDefault());
    }

    @Override
    public void httpDelete(Node graphName) {
        this.doDelete(this.target(graphName));
    }

    private boolean doDelete(String url) {
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            this.exec(url, null, httpDelete, false);
            return true;
        }
        catch (JenaHttpNotFoundException ex) {
            return false;
        }
    }

    @Override
    public void httpPost(Graph data) {
        this.doPost(this.targetDefault(), data);
    }

    @Override
    public void httpPost(Node graphName, Graph data) {
        this.doPost(this.target(graphName), data);
    }

    private void doPost(String url, Graph data) {
        HttpPost httpPost = new HttpPost(url);
        this.exec(url, data, httpPost, false);
    }

    @Override
    public void httpPatch(Graph data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void httpPatch(Node graphName, Graph data) {
        throw new UnsupportedOperationException();
    }

    private String targetDefault() {
        return this.remote + "?" + "default" + "=";
    }

    private String target(Node name) {
        if (!name.isURI()) {
            throw new JenaException("Not a URI: " + name);
        }
        String guri = name.getURI();
        guri = IRILib.encodeUriComponent(guri);
        return this.remote + "?" + "graph" + "=" + guri;
    }

    private static HttpParams createHttpParams() {
        BasicHttpParams httpParams$ = new BasicHttpParams();
        HttpProtocolParams.setVersion(httpParams$, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(httpParams$, "utf-8");
        HttpProtocolParams.setUseExpectContinue(httpParams$, true);
        HttpConnectionParams.setTcpNoDelay(httpParams$, true);
        HttpConnectionParams.setSocketBufferSize(httpParams$, 32768);
        HttpProtocolParams.setUserAgent(httpParams$, Jena.NAME + "/" + Jena.VERSION);
        return httpParams$;
    }

    private static String getHeader(HttpResponse response, String headerName) {
        Header h = response.getLastHeader(headerName);
        if (h == null) {
            return null;
        }
        return h.getValue();
    }

    private Graph exec(String targetStr, Graph graphToSend, HttpUriRequest httpRequest, boolean processBody) {
        HttpEntity entity;
        SystemDefaultHttpClient httpclient = new SystemDefaultHttpClient(httpParams);
        if (graphToSend != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Model model = ModelFactory.createModelForGraph(graphToSend);
            model.write(out, "RDF/XML");
            byte[] bytes = out.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            InputStreamEntity reqEntity = new InputStreamEntity(in, bytes.length);
            reqEntity.setContentType("application/rdf+xml");
            reqEntity.setContentEncoding("utf-8");
            entity = reqEntity;
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
        }
        FilterInputStream ts = null;
        try {
            HttpEntity entity2;
            HttpResponse response = httpclient.execute(httpRequest);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseMessage = response.getStatusLine().getReasonPhrase();
            if (HttpSC.isRedirection(responseCode)) {
                throw JenaHttpException.create(responseCode, responseMessage);
            }
            if (HttpSC.isClientError(responseCode) || HttpSC.isServerError(responseCode)) {
                throw JenaHttpException.create(responseCode, responseMessage);
            }
            if (responseCode == 204) {
                return null;
            }
            if (responseCode == 201) {
                return null;
            }
            if (responseCode != 200) {
                Log.warn(this, "Unexpected status code");
                throw JenaHttpException.create(responseCode, responseMessage);
            }
            String ct = DatasetGraphAccessorHTTP.getHeader(response, "Content-Type");
            if (ct == null) {
                entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    instream.close();
                }
                return null;
            }
            String x = DatasetGraphAccessorHTTP.getHeader(response, "Content-Type");
            String[] y = x.split(";");
            String contentType = null;
            if (y[0] != null) {
                contentType = y[0].trim();
            }
            String charset = null;
            if (y.length > 1 && y[1] != null) {
                charset = y[1].trim();
            }
            if ((entity2 = response.getEntity()) != null) {
                InputStream instream = entity2.getContent();
                ts = new TypedInputStream(instream, contentType, charset, null);
            }
            Graph graph = GraphFactory.createGraphMem();
            if (processBody) {
                this.readGraph(graph, (TypedInputStream)ts, null);
            }
            if (ts != null) {
                ts.close();
            }
            UnmodifiableGraph graph2 = new UnmodifiableGraph(graph);
            return graph2;
        }
        catch (IOException ex) {
            httpRequest.abort();
            return null;
        }
    }

    private void readGraph(Graph graph, TypedInputStream ts, String base) {
        Lang lang = WebContent.contentTypeToLang(ts.getContentType());
        if (lang == null) {
            throw new RiotException("Unknown lang for " + ts.getMediaType());
        }
        RDFDataMgr.read(graph, (InputStream)ts, lang);
    }
}

