/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.web.ContentProducer;
import org.apache.jena.riot.web.HttpResponseHandler;
import org.apache.jena.riot.web.HttpResponseLib;
import org.apache.jena.riot.web.TypedInputStreamHttp;
import org.apache.jena.web.JenaHttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOp {
    private static Logger log = LoggerFactory.getLogger(HttpOp.class);
    private static AtomicLong counter = new AtomicLong(0L);
    static Map<String, HttpResponseHandler> noActionHandlers = new HashMap<String, HttpResponseHandler>();

    public static void execHttpGet(String url, String acceptHeader, Map<String, HttpResponseHandler> handlers) {
        try {
            long id = counter.incrementAndGet();
            String requestURI = HttpOp.determineRequestURI(url);
            String baseIRI = HttpOp.determineBaseIRI(requestURI);
            HttpGet httpget = new HttpGet(requestURI);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, httpget.getMethod(), httpget.getURI().toString()));
            }
            if (acceptHeader != null) {
                httpget.addHeader("Accept", acceptHeader);
            }
            SystemDefaultHttpClient httpclient = new SystemDefaultHttpClient();
            HttpResponse response = httpclient.execute(httpget);
            HttpOp.httpResponse(id, response, baseIRI, handlers);
            httpclient.getConnectionManager().shutdown();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static TypedInputStreamHttp execHttpGet(String url, String acceptHeader) {
        try {
            SystemDefaultHttpClient httpclient;
            HttpResponse response;
            StatusLine statusLine;
            long id = counter.incrementAndGet();
            String requestURI = HttpOp.determineRequestURI(url);
            String baseIRI = HttpOp.determineBaseIRI(requestURI);
            HttpGet httpget = new HttpGet(requestURI);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, httpget.getMethod(), httpget.getURI().toString()));
            }
            if (acceptHeader != null) {
                httpget.addHeader("Accept", acceptHeader);
            }
            if ((statusLine = (response = (httpclient = new SystemDefaultHttpClient()).execute(httpget)).getStatusLine()).getStatusCode() == 404) {
                log.debug(String.format("[%d] %s %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                return null;
            }
            if (statusLine.getStatusCode() >= 400) {
                log.debug(String.format("[%d] %s %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                throw new HttpException(statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("[%d] %d %s :: (empty)", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                }
                return null;
            }
            MediaType mt = MediaType.create(entity.getContentType().getValue());
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %d %s :: %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase(), mt));
            }
            return new TypedInputStreamHttp(entity.getContent(), mt, httpclient.getConnectionManager());
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static String execHttpGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        SystemDefaultHttpClient httpclient = new SystemDefaultHttpClient();
        try {
            HttpResponse response = httpclient.execute(httpGet);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseMessage = response.getStatusLine().getReasonPhrase();
            if (200 != responseCode) {
                throw JenaHttpException.create(responseCode, responseMessage);
            }
            HttpEntity entity = response.getEntity();
            InputStream instream = entity.getContent();
            String string = IO.readWholeFileAsUTF8(instream);
            instream.close();
            return string;
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static void execHttpPost(String url, String contentType, String content) {
        HttpOp.execHttpPost(url, contentType, content, null, null, null);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, long length) {
        HttpOp.execHttpPost(url, contentType, input, length, null, null);
    }

    public static void execHttpPost(String url, String contentType, String content, String acceptType, Map<String, HttpResponseHandler> handlers, HttpContext httpContext) {
        StringEntity e2 = null;
        try {
            e2 = new StringEntity(content, "UTF-8");
            e2.setContentType(contentType);
            HttpOp.execHttpPost(url, e2, acceptType, handlers, httpContext);
        }
        catch (UnsupportedEncodingException e1) {
            try {
                throw new ARQInternalErrorException("Platform does not support required UTF-8");
            }
            catch (Throwable throwable) {
                HttpOp.closeEntity(e2);
                throw throwable;
            }
        }
        HttpOp.closeEntity(e2);
    }

    public static void execHttpPost(String url, String contentType, InputStream input, long length, String acceptType, Map<String, HttpResponseHandler> handlers) {
        InputStreamEntity e2 = new InputStreamEntity(input, length);
        e2.setContentType(contentType);
        e2.setContentEncoding("UTF-8");
        HttpOp.execHttpPost(url, e2, acceptType, handlers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPost(String url, String contentType, ContentProducer provider, String acceptType, Map<String, HttpResponseHandler> handlers) {
        EntityTemplate entity = new EntityTemplate(provider);
        entity.setContentType(contentType);
        try {
            HttpOp.execHttpPost(url, entity, acceptType, handlers, null);
        }
        finally {
            HttpOp.closeEntity(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPost(String url, HttpEntity provider, String acceptType, Map<String, HttpResponseHandler> handlers, HttpContext context) {
        try {
            long id = counter.incrementAndGet();
            String requestURI = HttpOp.determineRequestURI(url);
            String baseIRI = HttpOp.determineBaseIRI(requestURI);
            HttpPost httppost = new HttpPost(requestURI);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, httppost.getMethod(), httppost.getURI().toString()));
            }
            if (provider.getContentType() == null) {
                log.debug(String.format("[%d] No content type", new Object[0]));
            }
            SystemDefaultHttpClient httpclient = new SystemDefaultHttpClient();
            httppost.setEntity(provider);
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, context);
            HttpOp.httpResponse(id, response, baseIRI, handlers);
            httpclient.getConnectionManager().shutdown();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        finally {
            HttpOp.closeEntity(provider);
        }
    }

    public static void execHttpPostForm(String url, List<Pair<String, String>> params, Map<String, HttpResponseHandler> handlers) {
        HttpOp.execHttpPostForm(url, params, handlers, null);
    }

    public static void execHttpPostForm(String url, List<Pair<String, String>> params, Map<String, HttpResponseHandler> handlers, HttpContext httpContext) {
        try {
            long id = counter.incrementAndGet();
            String requestURI = url;
            String baseIRI = HttpOp.determineBaseIRI(requestURI);
            HttpPost httppost = new HttpPost(requestURI);
            httppost.setEntity(HttpOp.convertFormParams(params));
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, httppost.getMethod(), httppost.getURI().toString()));
            }
            SystemDefaultHttpClient httpclient = new SystemDefaultHttpClient();
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            HttpOp.httpResponse(id, response, baseIRI, handlers);
            httpclient.getConnectionManager().shutdown();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void execHttpPut(String url, String contentType, String content) {
        StringEntity e2 = null;
        try {
            e2 = new StringEntity(content, "UTF-8");
            e2.setContentType(contentType.toString());
            HttpOp.execHttpPut(url, e2);
        }
        catch (UnsupportedEncodingException e1) {
            try {
                throw new ARQInternalErrorException("Platform does not support required UTF-8");
            }
            catch (Throwable throwable) {
                HttpOp.closeEntity(e2);
                throw throwable;
            }
        }
        HttpOp.closeEntity(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execHttpPut(String url, String contentType, InputStream input, long length) {
        InputStreamEntity e2 = new InputStreamEntity(input, length);
        e2.setContentType(contentType);
        e2.setContentEncoding("UTF-8");
        try {
            HttpOp.execHttpPut(url, e2);
        }
        finally {
            HttpOp.closeEntity(e2);
        }
    }

    public static void execHttpPut(String url, HttpEntity entity) {
        try {
            long id = counter.incrementAndGet();
            String requestURI = url;
            String baseIRI = HttpOp.determineBaseIRI(requestURI);
            HttpPut httpput = new HttpPut(requestURI);
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%d] %s %s", id, httpput.getMethod(), httpput.getURI().toString()));
            }
            httpput.setEntity(entity);
            SystemDefaultHttpClient httpclient = new SystemDefaultHttpClient();
            HttpResponse response = httpclient.execute(httpput);
            HttpOp.httpResponse(id, response, baseIRI, null);
            httpclient.getConnectionManager().shutdown();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private static HttpEntity convertFormParams(List<Pair<String, String>> params) {
        try {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (Pair<String, String> p : params) {
                nvps.add(new BasicNameValuePair(p.getLeft(), p.getRight()));
            }
            UrlEncodedFormEntity e2 = new UrlEncodedFormEntity(nvps, "UTF-8");
            return e2;
        }
        catch (UnsupportedEncodingException e3) {
            throw new ARQInternalErrorException("Platform does not support required UTF-8");
        }
    }

    private static void closeEntity(HttpEntity entity) {
        if (entity == null) {
            return;
        }
        try {
            entity.getContent().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String determineRequestURI(String url) {
        String requestURI = url;
        if (requestURI.contains("#")) {
            int i = requestURI.indexOf(35);
            requestURI = requestURI.substring(0, i);
        }
        return requestURI;
    }

    private static String determineBaseIRI(String requestURI) {
        String baseIRI = requestURI;
        if (requestURI.contains("?")) {
            int i = requestURI.indexOf(63);
            baseIRI = requestURI.substring(0, i);
        }
        return baseIRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void httpResponse(long id, HttpResponse response, String baseIRI, Map<String, HttpResponseHandler> handlers) throws IllegalStateException, IOException {
        if (response == null) {
            return;
        }
        if (handlers == null) {
            handlers = noActionHandlers;
        }
        try {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 400) {
                log.debug(String.format("[%d] %s %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                throw new HttpException(statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
            }
            String ct = "*";
            MediaType mt = null;
            if (statusLine.getStatusCode() == 200) {
                HttpResponseHandler handler;
                String contentType = response.getFirstHeader("Content-Type").getValue();
                if (contentType != null) {
                    mt = MediaType.create(contentType);
                    ct = mt.getContentType();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("[%d] %d %s :: %s", id, statusLine.getStatusCode(), statusLine.getReasonPhrase(), mt));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug(String.format("[%d] %d %s :: (no content type)", id, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                }
                if ((handler = handlers.get(ct)) == null) {
                    handler = handlers.get("*");
                }
                if (handler != null) {
                    handler.handle(ct, baseIRI, response);
                } else {
                    log.warn(String.format("[%d] No handler found for %s", id, ct));
                }
            }
        }
        finally {
            HttpOp.closeEntity(response.getEntity());
        }
    }

    static {
        noActionHandlers.put("*", HttpResponseLib.nullResponse);
    }
}

