/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.riot.RiotException;

public abstract class IRIResolver {
    public static final IRIFactory iriFactory;
    private static boolean showExceptions;
    private static String globalBase;
    private static Object globalResolverLock;
    private static IRIResolver globalResolver;
    private static final int CacheSize = 1000;

    public static boolean checkIRI(String iriStr) {
        IRI iri2 = IRIResolver.parseIRI(iriStr);
        return iri2.hasViolation(false);
    }

    public static IRI parseIRI(String iriStr) {
        return iriFactory.create(iriStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveFileURL(String filename) throws IRIException {
        Object object = globalResolverLock;
        synchronized (object) {
            IRI r = globalResolver.resolve(filename);
            if (!r.getScheme().equalsIgnoreCase("file")) {
                return IRIResolver.resolveFileURL("./" + filename);
            }
            return r.toString();
        }
    }

    public static IRI resolve(String relStr, String baseStr) throws RiotException {
        return IRIResolver.exceptions(IRIResolver.resolveIRI(relStr, baseStr));
    }

    public static String resolveString(String relStr, String baseStr) throws RiotException {
        return IRIResolver.exceptions(IRIResolver.resolveIRI(relStr, baseStr)).toString();
    }

    public static String resolveString(String relStr) throws RiotException {
        return IRIResolver.exceptions(IRIResolver.resolveIRI(relStr)).toString();
    }

    public static IRI resolveIRI(String uriStr) {
        return IRIResolver.exceptions(globalResolver.resolve(uriStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRI resolveIRI(String relStr, String baseStr) {
        Object object = globalResolverLock;
        synchronized (object) {
            IRI i = iriFactory.create(relStr);
            if (i.isAbsolute()) {
                return globalResolver.getBaseIRI().create(i);
            }
            IRI base = iriFactory.create(baseStr);
            if ("file".equalsIgnoreCase(base.getScheme())) {
                return globalResolver.getBaseIRI().create(i);
            }
            return base.create(i);
        }
    }

    public static IRIResolver create() {
        return new IRIResolverNormal();
    }

    public static IRIResolver create(String baseStr) {
        return new IRIResolverNormal(baseStr);
    }

    public static IRIResolver create(IRI baseIRI) {
        return new IRIResolverNormal(baseIRI);
    }

    public static IRIResolver createNoResolve() {
        return new IRIResolverNoOp();
    }

    public static void suppressExceptions() {
        showExceptions = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRI chooseBaseURI() {
        Object object = globalResolverLock;
        synchronized (object) {
            return globalResolver.getBaseIRI();
        }
    }

    public String getBaseIRIasString() {
        IRI iri2 = this.getBaseIRI();
        if (iri2 == null) {
            return null;
        }
        return iri2.toString();
    }

    protected abstract IRI getBaseIRI();

    public abstract IRI resolve(String var1);

    public abstract IRI resolveSilent(String var1);

    public String resolveToString(String uriStr) {
        return this.resolve(uriStr).toString();
    }

    public String resolveToStringSilent(String uriStr) {
        return this.resolveSilent(uriStr).toString();
    }

    protected IRIResolver() {
    }

    private static IRI exceptions(IRI iri2) {
        if (!showExceptions) {
            return iri2;
        }
        if (!iri2.hasViolation(false)) {
            return iri2;
        }
        String msg = iri2.violations(false).next().getShortMessage();
        throw new RiotException(msg);
    }

    static {
        IRI cwd;
        iriFactory = new IRIFactory();
        showExceptions = true;
        iriFactory.useSpecificationIRI(true);
        iriFactory.useSchemeSpecificRules("*", true);
        iriFactory.setSameSchemeRelativeReferences("file");
        iriFactory.setIsError(44, false);
        iriFactory.setIsWarning(44, false);
        globalBase = IRILib.filenameToIRI("./");
        globalResolverLock = new Object();
        try {
            cwd = iriFactory.construct(globalBase);
        }
        catch (IRIException e2) {
            System.err.println("Unexpected IRIException in initializer: " + e2.getMessage());
            cwd = iriFactory.create("file:///");
            e2.printStackTrace(System.err);
        }
        globalResolver = IRIResolver.create(cwd);
    }

    static class IRIResolverNormal
    extends IRIResolver {
        private final IRI base;
        private Cache<String, IRI> resolvedIRIs = CacheFactory.createCache(1000);

        public IRIResolverNormal() {
            this((String)null);
        }

        public IRIResolverNormal(String baseS) {
            this.base = baseS == null ? IRIResolverNormal.chooseBaseURI() : globalResolver.resolveSilent(baseS);
        }

        public IRIResolverNormal(IRI baseIRI) {
            if (baseIRI == null) {
                baseIRI = IRIResolverNormal.chooseBaseURI();
            }
            this.base = baseIRI;
        }

        @Override
        public IRI getBaseIRI() {
            return this.base;
        }

        @Override
        public IRI resolve(String relURI) {
            return IRIResolver.exceptions(this.resolveSilent(relURI));
        }

        @Override
        public IRI resolveSilent(String relURI) {
            if (this.resolvedIRIs != null && this.resolvedIRIs.containsKey(relURI)) {
                return this.resolvedIRIs.get(relURI);
            }
            IRI iri2 = this.base.resolve(relURI);
            if (this.resolvedIRIs != null) {
                this.resolvedIRIs.put(relURI, iri2);
            }
            return iri2;
        }
    }

    static class IRIResolverNoOp
    extends IRIResolver {
        private Cache<String, IRI> resolvedIRIs = CacheFactory.createCache(1000);

        protected IRIResolverNoOp() {
        }

        @Override
        protected IRI getBaseIRI() {
            return null;
        }

        @Override
        public IRI resolve(String uriStr) {
            return IRIResolver.exceptions(this.resolveSilent(uriStr));
        }

        @Override
        public IRI resolveSilent(String uriStr) {
            if (this.resolvedIRIs != null && this.resolvedIRIs.containsKey(uriStr)) {
                return this.resolvedIRIs.get(uriStr);
            }
            IRI iri2 = iriFactory.create(uriStr);
            if (this.resolvedIRIs != null) {
                this.resolvedIRIs.put(uriStr, iri2);
            }
            return iri2;
        }

        @Override
        public String resolveToString(String uriStr) {
            return uriStr;
        }
    }
}

