/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import java.io.IOException;
import java.io.Writer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.out.NodeFormatter;

public abstract class NodeFormatterBase
implements NodeFormatter {
    @Override
    public void format(Writer w, Node n) {
        if (n.isBlank()) {
            this.formatBNode(w, n);
        } else if (n.isURI()) {
            this.formatURI(w, n);
        } else if (n.isLiteral()) {
            this.formatLiteral(w, n);
        } else if (n.isVariable()) {
            this.formatVar(w, n);
        } else if (Node.ANY.equals(n)) {
            try {
                w.write("ANY");
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        } else {
            throw new ARQInternalErrorException("Unknow node type: " + n);
        }
    }

    @Override
    public void formatURI(Writer w, Node n) {
        this.formatURI(w, n.getURI());
    }

    @Override
    public void formatBNode(Writer w, Node n) {
        this.formatBNode(w, n.getBlankNodeLabel());
    }

    @Override
    public void formatLiteral(Writer w, Node n) {
        String dt = n.getLiteralDatatypeURI();
        String lang = n.getLiteralLanguage();
        String lex = n.getLiteralLexicalForm();
        if (dt == null) {
            if (lang == null || lang.equals("")) {
                this.formatLitString(w, lex);
            } else {
                this.formatLitLang(w, lex, lang);
            }
        } else {
            this.formatLitDT(w, lex, dt);
        }
    }

    @Override
    public void formatVar(Writer w, Node n) {
        this.formatVar(w, n.getName());
    }
}

