/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.util.TypedStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.adapters.AdapterLib;
import org.apache.jena.riot.adapters.AdapterLocationMapper;
import org.apache.jena.riot.adapters.FileManagerModelCache;
import org.apache.jena.riot.stream.Locator;
import org.apache.jena.riot.stream.LocatorClassLoader;
import org.apache.jena.riot.stream.LocatorFile;
import org.apache.jena.riot.stream.LocatorURL;
import org.apache.jena.riot.stream.LocatorZip;
import org.apache.jena.riot.stream.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFileManager
extends FileManager {
    private static Logger log = LoggerFactory.getLogger(AdapterFileManager.class);
    private static AdapterFileManager instance = null;
    private final StreamManager streamManager;
    private FileManagerModelCache modelCache = new FileManagerModelCache();

    public static AdapterFileManager get() {
        if (instance == null) {
            instance = AdapterFileManager.makeGlobal();
        }
        return instance;
    }

    public static void setGlobalFileManager(AdapterFileManager globalFileManager) {
        instance = globalFileManager;
    }

    private AdapterFileManager() {
        this.streamManager = new StreamManager();
    }

    public AdapterFileManager(FileManager filemanager) {
        this();
        Iterator<com.hp.hpl.jena.util.Locator> iter = filemanager.locators();
        while (iter.hasNext()) {
            this.streamManager.addLocator(AdapterLib.convert(iter.next()));
        }
        LocationMapper locmap = filemanager.getLocationMapper();
        this.streamManager.setLocationMapper(AdapterLib.copyConvert(locmap));
    }

    public AdapterFileManager(StreamManager streamManager) {
        this(streamManager, null);
    }

    public AdapterFileManager(StreamManager streamManager, org.apache.jena.riot.stream.LocationMapper mapper) {
        if (streamManager == null) {
            streamManager = new StreamManager();
        }
        this.streamManager = streamManager;
        streamManager.setLocationMapper(mapper);
    }

    public static AdapterFileManager makeGlobal() {
        AdapterFileManager fMgr = new AdapterFileManager(StreamManager.get(), null);
        return fMgr;
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    public void setLocationMapper(LocationMapper mapper) {
        this.streamManager.setLocationMapper(AdapterLib.copyConvert(mapper));
    }

    @Override
    public LocationMapper getLocationMapper() {
        return new AdapterLocationMapper(this.streamManager.getLocationMapper());
    }

    @Override
    public Iterator<com.hp.hpl.jena.util.Locator> locators() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(com.hp.hpl.jena.util.Locator loc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLocator(com.hp.hpl.jena.util.Locator oldloc) {
        Locator loc = AdapterLib.convert(oldloc);
        log.debug("Add location: " + loc.getName());
        this.streamManager.addLocator(loc);
    }

    @Override
    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    @Override
    public void addLocatorFile(String dir) {
        LocatorFile fLoc = new LocatorFile(dir);
        this.streamManager.addLocator(fLoc);
    }

    @Override
    public void addLocatorClassLoader(ClassLoader cLoad) {
        LocatorClassLoader cLoc = new LocatorClassLoader(cLoad);
        this.streamManager.addLocator(cLoc);
    }

    @Override
    public void addLocatorURL() {
        LocatorURL loc = new LocatorURL();
        this.streamManager.addLocator(loc);
    }

    @Override
    public void addLocatorZip(String zfn) {
        LocatorZip loc = new LocatorZip(zfn);
        this.streamManager.addLocator(loc);
    }

    @Override
    public void resetCache() {
        this.modelCache.resetCache();
    }

    @Override
    public void setModelCaching(boolean state) {
        this.modelCache.setModelCaching(state);
    }

    @Override
    public boolean getCachingModels() {
        return this.modelCache.getCachingModels();
    }

    @Override
    public Model getFromCache(String filenameOrURI) {
        return this.modelCache.getFromCache(filenameOrURI);
    }

    @Override
    public boolean hasCachedModel(String filenameOrURI) {
        return this.modelCache.hasCachedModel(filenameOrURI);
    }

    @Override
    public void addCacheModel(String uri, Model m) {
        this.modelCache.addCacheModel(uri, m);
    }

    @Override
    public void removeCacheModel(String uri) {
        this.modelCache.removeCacheModel(uri);
    }

    @Override
    protected Model readModelWorker(Model model, String filenameOrURI, String baseURI, String syntax) {
        TypedInputStream in;
        String mappedURI = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !mappedURI.equals(filenameOrURI)) {
            log.debug("Map: " + filenameOrURI + " => " + mappedURI);
        }
        if (syntax == null && baseURI == null && mappedURI.startsWith("http:")) {
            model.read(mappedURI);
            return model;
        }
        if (syntax == null) {
            syntax = FileUtils.guessLang(mappedURI);
            if (syntax == null || syntax.equals("")) {
                syntax = "RDF/XML";
            }
            if (log.isDebugEnabled()) {
                log.debug("Syntax guess: " + syntax);
            }
        }
        if (baseURI == null) {
            baseURI = AdapterFileManager.chooseBaseURI(filenameOrURI);
        }
        if ((in = this.streamManager.openNoMapOrNull(mappedURI)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to locate '" + mappedURI + "'");
            }
            throw new NotFoundException("Not found: " + filenameOrURI);
        }
        if (in.getMediaType() != null) {
            // empty if block
        }
        model.read(in, baseURI, syntax);
        try {
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return model;
    }

    private static String chooseBaseURI(String baseURI) {
        String scheme = FileUtils.getScheme(baseURI);
        if (scheme != null && !scheme.equals("file")) {
            return baseURI;
        }
        return IRILib.filenameToIRI(baseURI);
    }

    @Override
    public InputStream open(String filenameOrURI) {
        return this.streamManager.open(filenameOrURI);
    }

    @Override
    public String mapURI(String filenameOrURI) {
        return this.streamManager.mapURI(filenameOrURI);
    }

    @Override
    public InputStream openNoMap(String filenameOrURI) {
        return this.streamManager.openNoMap(filenameOrURI);
    }

    @Override
    public TypedStream openNoMapOrNull(String filenameOrURI) {
        return AdapterLib.convert(this.streamManager.openNoMapOrNull(filenameOrURI));
    }

    @Override
    @Deprecated
    public String remap(String filenameOrURI) {
        return this.mapURI(filenameOrURI);
    }
}

