/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.LangRDFXML;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.stream.StreamManager;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFDataMgr {
    static Logger log;
    private static String riotBase;
    private static String streamManagerSymbolStr;
    public static Symbol streamManagerSymbol;

    public static void read(Model model, String uri) {
        RDFDataMgr.read(model.getGraph(), uri);
    }

    public static void read(Graph graph, String uri) {
        RDFDataMgr.read(graph, uri, null, null, null);
    }

    public static void read(Model model, String uri, Lang hintLang) {
        RDFDataMgr.read(model.getGraph(), uri, hintLang);
    }

    public static void read(Graph graph, String uri, Lang hintLang) {
        RDFDataMgr.read(graph, uri, hintLang, null);
    }

    public static void read(Model model, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(model.getGraph(), uri, base, hintLang);
    }

    public static void read(Graph graph, String uri, String base, Lang hintLang) {
        RDFDataMgr.read(graph, uri, base, hintLang, null);
    }

    public static void read(Model model, String uri, Context context) {
        RDFDataMgr.read(model.getGraph(), uri, context);
    }

    public static void read(Graph graph, String uri, Context context) {
        RDFDataMgr.read(graph, uri, null, context);
    }

    public static void read(Model model, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(model, uri, uri, hintLang, context);
    }

    public static void read(Graph graph, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(graph, uri, uri, hintLang, context);
    }

    public static void read(Model model, String uri, String base, Lang hintLang, Context context) {
        RDFDataMgr.read(model.getGraph(), uri, base, hintLang, context);
    }

    public static void read(Graph graph, String uri, String base, Lang hintLang, Context context) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.parse(dest, uri, base, hintLang, context);
    }

    public static void read(Model model, InputStream in, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, lang);
    }

    public static void read(Graph graph, InputStream in, Lang lang) {
        RDFDataMgr.read(graph, in, null, lang);
    }

    public static void read(Model model, InputStream in, String base, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, base, lang);
    }

    public static void read(Graph graph, InputStream in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.process(dest, new TypedInputStream(in), base, lang, null);
    }

    @Deprecated
    public static void read(Model model, Reader in, String base, Lang lang) {
        RDFDataMgr.read(model.getGraph(), in, base, lang);
    }

    @Deprecated
    public static void read(Graph graph, Reader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.processTriples(dest, base, in, lang, null);
    }

    public static void read(Model model, StringReader in, String base, Lang lang) {
        Graph g = model.getGraph();
        StreamRDF dest = StreamRDFLib.graph(g);
        RDFDataMgr.processTriples(dest, base, in, lang, null);
    }

    public static void read(Graph graph, StringReader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.graph(graph);
        RDFDataMgr.processTriples(dest, base, in, lang, null);
    }

    private static Model createModel() {
        return ModelFactory.createDefaultModel();
    }

    private static Graph createGraph() {
        return GraphFactory.createDefaultGraph();
    }

    private static Dataset createDataset() {
        return DatasetFactory.createMem();
    }

    private static DatasetGraph createDatasetGraph() {
        return DatasetGraphFactory.createMem();
    }

    public static Model loadModel(String uri) {
        Model m = RDFDataMgr.createModel();
        RDFDataMgr.read(m, uri);
        return m;
    }

    public static Model loadModel(String uri, Lang lang) {
        Model m = RDFDataMgr.createModel();
        RDFDataMgr.read(m, uri, lang);
        return m;
    }

    public static Graph loadGraph(String uri) {
        Graph g = RDFDataMgr.createGraph();
        RDFDataMgr.read(g, uri);
        return g;
    }

    public static Graph loadGraph(String uri, Lang lang) {
        Graph g = RDFDataMgr.createGraph();
        RDFDataMgr.read(g, uri, lang);
        return g;
    }

    public static Dataset loadDataset(String uri) {
        Dataset ds = RDFDataMgr.createDataset();
        RDFDataMgr.read(ds, uri);
        return ds;
    }

    public static Dataset loadDataset(String uri, Lang lang) {
        Dataset ds = RDFDataMgr.createDataset();
        RDFDataMgr.read(ds, uri, lang);
        return ds;
    }

    public static DatasetGraph loadDatasetGraph(String uri) {
        DatasetGraph ds = RDFDataMgr.createDatasetGraph();
        RDFDataMgr.read(ds, uri);
        return ds;
    }

    public static DatasetGraph loadDatasetGraph(String uri, Lang lang) {
        DatasetGraph ds = RDFDataMgr.createDatasetGraph();
        RDFDataMgr.read(ds, uri, lang);
        return ds;
    }

    public static void read(Dataset dataset, String uri) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri);
    }

    public static void read(DatasetGraph dataset, String uri) {
        RDFDataMgr.read(dataset, uri, null, null);
    }

    public static void read(Dataset dataset, String uri, Lang hintLang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, hintLang);
    }

    public static void read(DatasetGraph dataset, String uri, Lang hintLang) {
        RDFDataMgr.read(dataset, uri, hintLang, null);
    }

    public static void read(Dataset dataset, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, hintLang, context);
    }

    public static void read(DatasetGraph dataset, String uri, Lang hintLang, Context context) {
        RDFDataMgr.read(dataset, uri, uri, hintLang, context);
    }

    public static void read(Dataset dataset, String uri, String base, Lang hintLang, Context context) {
        RDFDataMgr.read(dataset.asDatasetGraph(), uri, uri, hintLang, context);
    }

    public static void read(DatasetGraph dataset, String uri, String base, Lang hintLang, Context context) {
        StreamRDF sink = StreamRDFLib.dataset(dataset);
        RDFDataMgr.parse(sink, uri, base, hintLang, context);
    }

    public static void read(Dataset dataset, InputStream in, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, lang);
    }

    public static void read(DatasetGraph dataset, InputStream in, Lang lang) {
        RDFDataMgr.read(dataset, in, null, lang);
    }

    public static void read(Dataset dataset, InputStream in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    public static void read(DatasetGraph dataset, InputStream in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.process(dest, new TypedInputStream(in), base, lang, null);
    }

    @Deprecated
    public static void read(Dataset dataset, Reader in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    @Deprecated
    public static void read(DatasetGraph dataset, Reader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.process(dest, base, in, lang, null);
    }

    public static void read(Dataset dataset, StringReader in, String base, Lang lang) {
        RDFDataMgr.read(dataset.asDatasetGraph(), in, base, lang);
    }

    public static void read(DatasetGraph dataset, StringReader in, String base, Lang lang) {
        StreamRDF dest = StreamRDFLib.dataset(dataset);
        RDFDataMgr.process(dest, base, in, lang, null);
    }

    public static void parse(StreamRDF sink, String uri) {
        RDFDataMgr.parse(sink, uri, null, null);
    }

    public static void parse(StreamRDF sink, String uri, Lang hintLang, Context context) {
        RDFDataMgr.parse(sink, uri, uri, hintLang, context);
    }

    public static void parse(StreamRDF sink, String uri, String base, Lang hintLang, Context context) {
        TypedInputStream in;
        if (uri == null) {
            throw new IllegalArgumentException("URI to read from is null");
        }
        if (base == null) {
            base = IRIResolver.resolveFileURL(uri);
        }
        if (hintLang == null) {
            hintLang = RDFLanguages.filenameToLang(uri);
        }
        if ((in = RDFDataMgr.open(uri, context)) == null) {
            throw new RiotException("Not found: " + uri);
        }
        RDFDataMgr.process(sink, in, base, hintLang, context);
        IO.close(in);
    }

    public static void parse(StreamRDF sink, InputStream in, String base, Lang hintLang, Context context) {
        RDFDataMgr.process(sink, new TypedInputStream(in), base, hintLang, context);
    }

    public static void parse(StreamRDF sink, TypedInputStream in, String base) {
        Lang hintLang = RDFLanguages.contentTypeToLang(in.getMediaType());
        RDFDataMgr.process(sink, new TypedInputStream(in), base, hintLang, null);
    }

    public static TypedInputStream open(String filenameOrURI) {
        return RDFDataMgr.open(filenameOrURI, (Context)null);
    }

    public static TypedInputStream open(String filenameOrURI, Context context) {
        StreamManager sMgr = StreamManager.get();
        if (context != null) {
            try {
                sMgr = (StreamManager)context.get(streamManagerSymbol, context);
            }
            catch (ClassCastException ex) {
                log.warn("Context symbol '" + streamManagerSymbol + "' is not a " + Utils.classShortName(StreamManager.class));
            }
        }
        return RDFDataMgr.open(filenameOrURI, sMgr);
    }

    public static TypedInputStream open(String filenameOrURI, StreamManager streamManager) {
        TypedInputStream in = streamManager.open(filenameOrURI);
        if (in == null) {
            if (log.isDebugEnabled()) {
                log.debug("Not Found: " + filenameOrURI);
            }
            throw new RiotNotFoundException("Not found: " + filenameOrURI);
        }
        if (log.isDebugEnabled()) {
            log.debug("Found: " + filenameOrURI);
        }
        return in;
    }

    private static void process(StreamRDF destination, TypedInputStream in, String baseUri, Lang hintLang, Context context) {
        ContentType ct = RDFDataMgr.determineCT(baseUri, in.getContentType(), hintLang);
        if (ct == null) {
            throw new RiotException("Failed to determine the triples content type: (URI=" + baseUri + " : stream=" + in.getContentType() + " : hint=" + hintLang + ")");
        }
        ReaderRIOT reader = RDFDataMgr.getReader(ct);
        if (reader == null) {
            throw new RiotException("No triples reader for content type: " + ct.getContentType());
        }
        reader.read(in, baseUri, ct, destination, context);
    }

    private static ReaderRIOT getReader(ContentType ct) {
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        ReaderRIOTFactory r = RDFParserRegistry.getFactory(lang);
        if (r == null) {
            return null;
        }
        return r.create(lang);
    }

    private static void processTriples(StreamRDF output, String base, Reader in, Lang lang, Context context) {
        LangRIOT parser;
        ContentType ct = RDFDataMgr.determineCT(base, null, lang);
        if (ct == null) {
            throw new RiotException("Failed to determine the triples content type: (URI=" + base + " : hint=" + lang + ")");
        }
        if (lang == null) {
            throw new RiotException("No language specificied");
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFXML, lang)) {
            parser = LangRDFXML.create(in, base, base, ErrorHandlerFactory.errorHandlerStd, output);
        } else {
            Tokenizer tokenizer = RDFLanguages.RDFJSON.equals(lang) ? new TokenizerJSON(PeekReader.make(in)) : TokenizerFactory.makeTokenizer(in);
            parser = RiotReader.createParser(tokenizer, lang, base, output);
        }
        parser.parse();
    }

    private static void process(StreamRDF dest, String base, Reader in, Lang hintLang, Context context) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer(in);
        LangRIOT parser = RiotReader.createParser(tokenizer, hintLang, base, dest);
        parser.parse();
    }

    private static ContentType determineCT(String target, String ctStr, Lang hintLang) {
        ContentType ct;
        boolean isTextPlain = "text/plain".equals(ctStr);
        if (ctStr != null) {
            ctStr = WebContent.contentTypeCanonical(ctStr);
        }
        ContentType contentType = ct = ctStr == null ? null : ContentType.parse(ctStr);
        if (ct == null || isTextPlain) {
            ct = RDFLanguages.guessContentType(target);
        }
        if (ct == null && hintLang != null) {
            ct = hintLang.getContentType();
        }
        return ct;
    }

    static {
        RIOT.init();
        log = LoggerFactory.getLogger(RDFDataMgr.class);
        riotBase = "http://jena.apache.org/riot/";
        streamManagerSymbolStr = riotBase + "streamManager";
        streamManagerSymbol = Symbol.create(streamManagerSymbolStr);
    }
}

