/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.fuseki.validation.ValidatorBase;

public class UpdateValidator
extends ValidatorBase {
    static final String paramLineNumbers = "linenumbers";
    static final String paramFormat = "outputFormat";
    static final String paramUpdate = "update";
    static final String paramSyntax = "languageSyntax";

    @Override
    protected void execute(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            Syntax language;
            String[] args = httpRequest.getParameterValues(paramUpdate);
            if (args == null || args.length == 0) {
                httpResponse.sendError(400, "No update parameter to validator");
                return;
            }
            if (args.length > 1) {
                httpResponse.sendError(400, "Too many update parameters");
                return;
            }
            final String updateString = httpRequest.getParameter(paramUpdate).replaceAll("(\r|\n| )*$", "");
            String updateSyntax = httpRequest.getParameter(paramSyntax);
            if (updateSyntax == null || updateSyntax.equals("")) {
                updateSyntax = "SPARQL";
            }
            if ((language = Syntax.lookup(updateSyntax)) == null) {
                httpResponse.sendError(400, "Unknown syntax: " + updateSyntax);
                return;
            }
            String lineNumbersArg = httpRequest.getParameter(paramLineNumbers);
            String[] a = httpRequest.getParameterValues(paramFormat);
            boolean outputSPARQL = true;
            boolean lineNumbers = true;
            if (lineNumbersArg != null) {
                lineNumbers = lineNumbersArg.equalsIgnoreCase("true") || lineNumbersArg.equalsIgnoreCase("yes");
            }
            UpdateValidator.setHeaders(httpResponse);
            ServletOutputStream outStream = httpResponse.getOutputStream();
            outStream.println("<html>");
            UpdateValidator.printHead(outStream, "SPARQL Update Validation Report");
            outStream.println("<body>");
            outStream.println("<h1>SPARQL Update Validator</h1>");
            outStream.println("<p>Input:</p>");
            Content c = new Content(){

                @Override
                public void print(IndentedWriter out) {
                    out.print(updateString);
                }
            };
            this.output(outStream, c, lineNumbers);
            UpdateRequest request = null;
            try {
                request = UpdateFactory.create(updateString, "http://example/base/", language);
            }
            catch (ARQException ex) {
                outStream.println("<p>Syntax error:</p>");
                UpdateValidator.startFixed(outStream);
                outStream.println(ex.getMessage());
                UpdateValidator.finishFixed(outStream);
            }
            catch (RuntimeException ex) {
                outStream.println("<p>Internal error:</p>");
                UpdateValidator.startFixed(outStream);
                outStream.println(ex.getMessage());
                UpdateValidator.finishFixed(outStream);
            }
            final UpdateRequest updateRequest = request;
            if (updateRequest != null && outputSPARQL) {
                outStream.println("<p>Formatted, parsed update request:</p>");
                Content c2 = new Content(){

                    @Override
                    public void print(IndentedWriter out) {
                        updateRequest.output(out);
                    }
                };
                this.output(outStream, c2, lineNumbers);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (Exception ex) {
            serviceLog.warn("Exception in doGet", ex);
        }
    }

    private void output(ServletOutputStream outStream, Content content, boolean lineNumbers) throws IOException {
        UpdateValidator.startFixed(outStream);
        IndentedLineBuffer out = new IndentedLineBuffer(lineNumbers);
        content.print(out);
        out.flush();
        String x = UpdateValidator.htmlQuote(out.asString());
        byte[] b = x.getBytes("UTF-8");
        outStream.write(b);
        UpdateValidator.finishFixed(outStream);
    }

    static interface Content {
        public void print(IndentedWriter var1);
    }
}

