/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.fuseki.validation.ValidatorBase;

public class QueryValidator
extends ValidatorBase {
    static final String paramLineNumbers = "linenumbers";
    static final String paramFormat = "outputFormat";
    static final String paramQuery = "query";
    static final String paramSyntax = "languageSyntax";

    @Override
    protected void execute(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            Syntax language;
            String[] args = httpRequest.getParameterValues(paramQuery);
            if (args == null || args.length == 0) {
                httpResponse.sendError(400, "No query parameter to validator");
                return;
            }
            if (args.length > 1) {
                httpResponse.sendError(400, "Too many query parameters");
                return;
            }
            final String queryString = httpRequest.getParameter(paramQuery).replaceAll("(\r|\n| )*$", "");
            String querySyntax = httpRequest.getParameter(paramSyntax);
            if (querySyntax == null || querySyntax.equals("")) {
                querySyntax = "SPARQL";
            }
            if ((language = Syntax.lookup(querySyntax)) == null) {
                httpResponse.sendError(400, "Unknown syntax: " + querySyntax);
                return;
            }
            String lineNumbersArg = httpRequest.getParameter(paramLineNumbers);
            String[] a = httpRequest.getParameterValues(paramFormat);
            boolean outputSPARQL = false;
            boolean outputPrefix = false;
            boolean outputAlgebra = false;
            boolean outputQuads = false;
            boolean outputOptimized = false;
            boolean outputOptimizedQuads = false;
            if (a != null) {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i].equals("sparql")) {
                        outputSPARQL = true;
                    }
                    if (a[i].equals("prefix")) {
                        outputPrefix = true;
                    }
                    if (a[i].equals("algebra")) {
                        outputAlgebra = true;
                    }
                    if (a[i].equals("quads")) {
                        outputQuads = true;
                    }
                    if (a[i].equals("opt")) {
                        outputOptimized = true;
                    }
                    if (!a[i].equals("optquads")) continue;
                    outputOptimizedQuads = true;
                }
            }
            boolean lineNumbers = true;
            if (lineNumbersArg != null) {
                lineNumbers = lineNumbersArg.equalsIgnoreCase("true") || lineNumbersArg.equalsIgnoreCase("yes");
            }
            QueryValidator.setHeaders(httpResponse);
            ServletOutputStream outStream = httpResponse.getOutputStream();
            outStream.println("<html>");
            QueryValidator.printHead(outStream, "SPARQL Query Validation Report");
            outStream.println("<body>");
            outStream.println("<h1>SPARQL Query Validator</h1>");
            outStream.println("<p>Input:</p>");
            Content c = new Content(){

                @Override
                public void print(IndentedWriter out) {
                    out.print(queryString);
                }
            };
            this.output(outStream, c, lineNumbers);
            Query query2 = null;
            try {
                query2 = QueryFactory.create(queryString, "http://example/base/", language);
            }
            catch (ARQException ex) {
                outStream.println("<p>Syntax error:</p>");
                QueryValidator.startFixed(outStream);
                outStream.println(ex.getMessage());
                QueryValidator.finishFixed(outStream);
            }
            catch (RuntimeException ex) {
                outStream.println("<p>Internal error:</p>");
                QueryValidator.startFixed(outStream);
                outStream.println(ex.getMessage());
                QueryValidator.finishFixed(outStream);
            }
            if (query2 != null) {
                if (outputSPARQL) {
                    this.outputSyntax(outStream, query2, lineNumbers);
                }
                if (outputAlgebra) {
                    this.outputAlgebra(outStream, query2, lineNumbers);
                }
                if (outputQuads) {
                    this.outputAlgebraQuads(outStream, query2, lineNumbers);
                }
                if (outputOptimized) {
                    this.outputAlgebraOpt(outStream, query2, lineNumbers);
                }
                if (outputOptimizedQuads) {
                    this.outputAlgebraOptQuads(outStream, query2, lineNumbers);
                }
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (Exception ex) {
            serviceLog.warn("Exception in doGet", ex);
        }
    }

    private void outputSyntax(ServletOutputStream outStream, final Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Formatted, parsed query:</p>");
        Content c = new Content(){

            @Override
            public void print(IndentedWriter out) {
                query2.serialize(out);
            }
        };
        this.output(outStream, c, lineNumbers);
    }

    private void outputAlgebra(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Algebra structure:</p>");
        Op op = Algebra.compile(query2);
        this.output(outStream, query2, op, lineNumbers);
    }

    private void outputAlgebraOpt(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Alebgra, with general triple optimizations:</p>");
        Op op = Algebra.optimize(Algebra.compile(query2));
        this.output(outStream, query2, op, lineNumbers);
    }

    private void outputAlgebraQuads(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Quad structure:</p>");
        Op op = Algebra.toQuadForm(Algebra.compile(query2));
        this.output(outStream, query2, op, lineNumbers);
    }

    private void outputAlgebraOptQuads(ServletOutputStream outStream, Query query2, boolean lineNumbers) throws IOException {
        outStream.println("<p>Alebgra, with general quads optimizations:</p>");
        Op op = Algebra.optimize(Algebra.toQuadForm(Algebra.compile(query2)));
        this.output(outStream, query2, op, lineNumbers);
    }

    private void output(ServletOutputStream outStream, Query query2, final Op op, boolean lineNumbers) throws IOException {
        final SerializationContext sCxt = new SerializationContext(query2);
        Content c = new Content(){

            @Override
            public void print(IndentedWriter out) {
                op.output(out, sCxt);
            }
        };
        this.output(outStream, c, lineNumbers);
    }

    private void output(ServletOutputStream outStream, Content content, boolean lineNumbers) throws IOException {
        QueryValidator.startFixed(outStream);
        IndentedLineBuffer out = new IndentedLineBuffer(lineNumbers);
        content.print(out);
        out.flush();
        String x = QueryValidator.htmlQuote(out.asString());
        byte[] b = x.getBytes("UTF-8");
        outStream.write(b);
        QueryValidator.finishFixed(outStream);
    }

    static interface Content {
        public void print(IndentedWriter var1);
    }
}

