/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.servlets.ResponseModel;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.riot.web.HttpOp;

public abstract class SPARQL_Query
extends SPARQL_Protocol {
    protected static List<String> allParams = Arrays.asList("query", "default-graph-uri", "named-graph-uri", "query-ref", "stylesheet", "accept", "output", "format", "callback", "force-accept", "timeout");

    public SPARQL_Query(boolean verbose) {
        super(verbose);
    }

    public SPARQL_Query() {
        this(false);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Query.setCommonHeaders(response);
        response.setHeader("Allow", "GET,OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected final void perform(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response) {
        HttpActionQuery action = new HttpActionQuery(id, desc, request, response, this.verbose_debug);
        if (request.getMethod().equals("GET")) {
            this.executeWithParameter(action);
            return;
        }
        MediaType ct = FusekiLib.contentType(request);
        String incoming = ct.getContentType();
        if ("application/sparql-query".equals(incoming)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(incoming)) {
            this.executeWithParameter(action);
            return;
        }
        SPARQL_Query.error(415, "Bad content type: " + incoming);
    }

    @Override
    protected void validate(HttpServletRequest request) {
        String method = request.getMethod().toUpperCase();
        if (!"POST".equals(method) && !"GET".equals(method)) {
            SPARQL_Query.errorMethodNotAllowed("Not a GET or POST request");
        }
        if ("GET".equals(method) && request.getQueryString() == null) {
            SPARQL_Query.warning("Service Description / SPARQL Query / " + request.getRequestURI());
            SPARQL_Query.errorNotFound("Service Description: " + request.getRequestURI());
        }
        this.validate(request, allParams);
        this.validateRequest(request);
    }

    protected abstract void validateRequest(HttpServletRequest var1);

    protected void validate(HttpServletRequest request, Collection<String> params) {
        MediaType ct = FusekiLib.contentType(request);
        boolean mustHaveQueryParam = true;
        if (ct != null) {
            String incoming = ct.getContentType();
            if ("application/sparql-query".equals(incoming)) {
                mustHaveQueryParam = false;
            } else if (!"application/x-www-form-urlencoded".equals(incoming)) {
                SPARQL_Query.error(415, "Unsupported: " + incoming);
            }
        }
        if (mustHaveQueryParam) {
            String queryStr;
            int N = SPARQL_Query.countParamOccurences(request, "query");
            if (N == 0) {
                SPARQL_Query.errorBadRequest("SPARQL Query: No 'query=' parameter");
            }
            if (N > 1) {
                SPARQL_Query.errorBadRequest("SPARQL Query: Multiple 'query=' parameters");
            }
            if ((queryStr = request.getParameter("query")) == null) {
                SPARQL_Query.errorBadRequest("SPARQL Query: No query specified (no 'query=' found)");
            }
            if (queryStr.isEmpty()) {
                SPARQL_Query.errorBadRequest("SPARQL Query: Empty query string");
            }
        }
        if (params != null) {
            Enumeration<String> en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                if (params.contains(name)) continue;
                SPARQL_Query.warning("SPARQL Query: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    private void executeWithParameter(HttpActionQuery action) {
        String queryString = action.request.getParameter("query");
        this.execute(queryString, action);
    }

    private void executeBody(HttpActionQuery action) {
        String queryString = null;
        try {
            ServletInputStream input = action.request.getInputStream();
            queryString = IO.readWholeFileAsUTF8(input);
        }
        catch (IOException ex) {
            SPARQL_Query.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String queryString, HttpActionQuery action) {
        String queryStringLog = SPARQL_Query.formatForLog(queryString);
        if (this.verbose_debug || action.verbose) {
            log.info(String.format("[%d] Query = \n%s", action.id, queryString));
        } else {
            log.info(String.format("[%d] Query = %s", action.id, queryStringLog));
        }
        Query query2 = null;
        try {
            query2 = QueryFactory.create(queryString, Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query2);
        }
        catch (QueryParseException ex) {
            SPARQL_Query.errorBadRequest("Parse error: \n" + queryString + "\n\r" + SPARQL_Query.messageForQPE(ex));
        }
        catch (QueryException ex) {
            SPARQL_Query.errorBadRequest("Error: \n" + queryString + "\n\r" + ex.getMessage());
        }
        this.validateQuery(action, query2);
        action.beginRead();
        QueryExecution qExec = null;
        try {
            Dataset dataset = this.decideDataset(action, query2, queryStringLog);
            qExec = this.createQueryExecution(query2, dataset);
            SPARQLResult result = this.executeQuery(action, qExec, query2, queryStringLog);
            this.sendResults(action, result, query2.getPrologue());
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
            action.endRead();
        }
    }

    protected abstract void validateQuery(HttpActionQuery var1, Query var2);

    protected QueryExecution createQueryExecution(Query query2, Dataset dataset) {
        return QueryExecutionFactory.create(query2, dataset);
    }

    protected SPARQLResult executeQuery(HttpActionQuery action, QueryExecution qExec, Query query2, String queryStringLog) {
        this.setAnyTimeouts(qExec, action);
        if (query2.isSelectType()) {
            ResultSet rs = qExec.execSelect();
            rs.hasNext();
            log.info(String.format("[%d] exec/select", action.id));
            return new SPARQLResult(rs);
        }
        if (query2.isConstructType()) {
            Model model = qExec.execConstruct();
            log.info(String.format("[%d] exec/construct", action.id));
            return new SPARQLResult(model);
        }
        if (query2.isDescribeType()) {
            Model model = qExec.execDescribe();
            log.info(String.format("[%d] exec/describe", action.id));
            return new SPARQLResult(model);
        }
        if (query2.isAskType()) {
            boolean b = qExec.execAsk();
            log.info(String.format("[%d] exec/ask", action.id));
            return new SPARQLResult(b);
        }
        SPARQL_Query.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    private void setAnyTimeouts(QueryExecution qexec, HttpActionQuery action) {
        if (!action.getDatasetRef().allowTimeoutOverride) {
            return;
        }
        long desiredTimeout = Long.MAX_VALUE;
        String timeoutHeader = action.request.getHeader("Timeout");
        String timeoutParameter = action.request.getParameter("timeout");
        if (timeoutHeader != null) {
            try {
                desiredTimeout = (int)Float.parseFloat(timeoutHeader) * 1000;
            }
            catch (NumberFormatException e2) {
                throw new FusekiException("Timeout header must be a number", e2);
            }
        }
        if (timeoutParameter != null) {
            try {
                desiredTimeout = (int)Float.parseFloat(timeoutParameter) * 1000;
            }
            catch (NumberFormatException e3) {
                throw new FusekiException("timeout parameter must be a number", e3);
            }
        }
        desiredTimeout = Math.min(action.getDatasetRef().maximumTimeoutOverride, desiredTimeout);
        if (desiredTimeout != Long.MAX_VALUE) {
            qexec.setTimeout(desiredTimeout);
        }
    }

    protected abstract Dataset decideDataset(HttpActionQuery var1, Query var2, String var3);

    protected void sendResults(HttpActionQuery action, SPARQLResult result, Prologue qPrologue) {
        if (result.isResultSet()) {
            ResponseResultSet.doResponseResultSet(result.getResultSet(), qPrologue, action.request, action.response);
        } else if (result.isGraph()) {
            ResponseModel.doResponseModel(result.getModel(), action.request, action.response);
        } else if (result.isBoolean()) {
            ResponseResultSet.doResponseResultSet(result.getBooleanResult(), action.request, action.response);
        } else {
            SPARQL_Query.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query2) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query2.serialize(out);
        return out.asString();
    }

    private String getRemoteString(String queryURI) {
        return HttpOp.execHttpGet(queryURI);
    }

    protected class HttpActionQuery
    extends SPARQL_Protocol.HttpActionProtocol {
        DatasetDescription datasetDesc;

        public HttpActionQuery(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(SPARQL_Query.this, id, desc, request, response, verbose);
            this.datasetDesc = null;
        }
    }
}

