/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.core.Prologue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseResultSet {
    private static Logger log = LoggerFactory.getLogger(ResponseResultSet.class);
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputSPARQL = "sparql";
    private static final String contentOutputText = "text";
    private static final String contentOutputCSV = "csv";
    private static final String contentOutputTSV = "tsv";
    public static Map<String, String> shortNamesResultSet = new HashMap<String, String>();
    static AcceptList prefContentTypeResultSet;
    static AcceptList prefContentTypeRDF;

    public static void doResponseResultSet(Boolean booleanResult, HttpServletRequest request, HttpServletResponse response) {
        ResponseResultSet.doResponseResultSet$(null, booleanResult, null, request, response);
    }

    public static void doResponseResultSet(ResultSet resultSet, Prologue qPrologue, HttpServletRequest request, HttpServletResponse response) {
        ResponseResultSet.doResponseResultSet$(resultSet, null, qPrologue, request, response);
    }

    private static void doResponseResultSet$(final ResultSet resultSet, final Boolean booleanResult, final Prologue qPrologue, HttpServletRequest request, HttpServletResponse response) {
        String forceAccept;
        String outputField;
        if (resultSet == null && booleanResult == null) {
            log.warn("doResponseResult: Both result set and boolean result are null");
            throw new FusekiException("Both result set and boolean result are null");
        }
        if (resultSet != null && booleanResult != null) {
            log.warn("doResponseResult: Both result set and boolean result are set");
            throw new FusekiException("Both result set and boolean result are set");
        }
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rsOffer, DEF.acceptRSXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseOps.paramOutput(request, shortNamesResultSet)) != null) {
            mimeType = outputField;
        }
        String serializationType = mimeType;
        String contentType = mimeType;
        final String stylesheetURL = ResponseOps.paramStylesheet(request);
        if (stylesheetURL != null && Lib.equal(serializationType, "application/sparql-results+xml")) {
            contentType = "application/xml";
        }
        if ((forceAccept = ResponseOps.paramForceAccept(request)) != null) {
            contentType = "text/plain";
        }
        if (Lib.equal(serializationType, "application/sparql-results+xml")) {
            try {
                ResponseResultSet.sparqlXMLOutput(contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, resultSet, stylesheetURL);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, booleanResult, stylesheetURL);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/XML]" + ex, ex);
            }
            return;
        }
        if (Lib.equal(serializationType, "application/sparql-results+json")) {
            try {
                ResponseResultSet.jsonOutput(contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, booleanResult);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/JSON] " + ex, ex);
            }
            return;
        }
        if (Lib.equal(serializationType, "text/plain")) {
            try {
                ResponseResultSet.textOutput(contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.out((OutputStream)out, resultSet, qPrologue);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.out((OutputStream)out, booleanResult);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/Text] " + ex, ex);
            }
            return;
        }
        if (Lib.equal(serializationType, "text/csv") || Lib.equal(serializationType, "text/tab-separated-values")) {
            try {
                OutputContent output = serializationType.equals("text/csv") ? new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, booleanResult);
                        }
                    }
                } : new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, booleanResult);
                        }
                    }
                };
                ResponseResultSet.textOutput(contentType, output, request, response);
                response.flushBuffer();
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/CSV-TSV] " + ex, ex);
            }
            return;
        }
        SPARQL_ServletBase.errorBadRequest("Can't determine output serialization: " + serializationType);
    }

    private static void output(String contentType, String charset, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ResponseResultSet.setHttpResponse(httpRequest, httpResponse, contentType, charset);
            httpResponse.setStatus(200);
            ServletOutputStream out = httpResponse.getOutputStream();
            proc.output(out);
            out.flush();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    public static void setHttpResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String contentType, String charset) {
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Pragma", "no-cache");
        if (contentType != null) {
            if (charset != null && !ResponseResultSet.isXML(contentType)) {
                contentType = contentType + "; charset=" + charset;
            }
            log.trace("Content-Type for response: " + contentType);
            httpResponse.setContentType(contentType);
        }
    }

    private static boolean isXML(String contentType) {
        return contentType.equals("application/rdf+xml") || contentType.equals("application/sparql-results+xml") || contentType.equals("application/xml");
    }

    private static void sparqlXMLOutput(String contentType, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ResponseResultSet.output(contentType, null, proc, httpRequest, httpResponse);
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    private static void jsonOutput(String contentType, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String callback = ResponseOps.paramCallback(httpRequest);
            callback = StringUtils.replaceChars(callback, "\r", "");
            callback = StringUtils.replaceChars(callback, "\n", "");
            ServletOutputStream out = httpResponse.getOutputStream();
            if (callback != null) {
                out.print(callback);
                out.println("(");
            }
            ResponseResultSet.output(contentType, "utf-8", proc, httpRequest, httpResponse);
            if (callback != null) {
                out.println(")");
            }
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    private static void textOutput(String contentType, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ServletOutputStream out = httpResponse.getOutputStream();
            ResponseResultSet.output(contentType, "utf-8", proc, httpRequest, httpResponse);
            out.flush();
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    static {
        ResponseOps.put(shortNamesResultSet, contentOutputJSON, "application/sparql-results+json");
        ResponseOps.put(shortNamesResultSet, contentOutputSPARQL, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputXML, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputText, "text/plain");
        ResponseOps.put(shortNamesResultSet, contentOutputCSV, "text/csv");
        ResponseOps.put(shortNamesResultSet, contentOutputTSV, "text/tab-separated-values");
        prefContentTypeResultSet = DEF.rsOffer;
        prefContentTypeRDF = DEF.rdfOffer;
    }

    static interface OutputContent {
        public void output(ServletOutputStream var1);
    }
}

