/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.xmloutput.RDFXMLWriterI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.conneg.WebLib;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.WebContent;

public class ResponseModel {
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputText = "text";
    private static final String contentOutputTTL = "ttl";
    private static final String contentOutputNT = "nt";
    public static Map<String, String> shortNamesModel = new HashMap<String, String>();

    public static void doResponseModel(Model model, HttpServletRequest request, HttpServletResponse response) {
        Lang lang;
        RDFWriter rdfw;
        String outputField;
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rdfOffer, DEF.acceptRDFXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseOps.paramOutput(request, shortNamesModel)) != null) {
            mimeType = outputField;
        }
        String writerMimeType = mimeType;
        if (mimeType == null) {
            Fuseki.requestLog.warn("Can't find MIME type for response");
            String x = WebLib.getAccept(request);
            String msg = x == null ? "No Accept: header" : "Accept: " + x + " : Not understood";
            SPARQL_ServletBase.error(406, msg);
        }
        String contentType = mimeType;
        String charset = "utf-8";
        String forceAccept = ResponseOps.paramForceAccept(request);
        if (forceAccept != null) {
            contentType = "text/plain";
            charset = "utf-8";
        }
        if ((rdfw = FusekiLib.chooseWriter(lang = WebContent.contentTypeToLang(contentType))) instanceof RDFXMLWriterI) {
            rdfw.setProperty("showXmlDeclaration", "true");
        }
        try {
            ResponseResultSet.setHttpResponse(request, response, contentType, charset);
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            rdfw.write(model, out, null);
            out.flush();
        }
        catch (Exception ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    static {
        ResponseOps.put(shortNamesModel, contentOutputJSON, "application/rdf+json");
        ResponseOps.put(shortNamesModel, contentOutputXML, "application/rdf+xml");
        ResponseOps.put(shortNamesModel, contentOutputText, "text/turtle");
        ResponseOps.put(shortNamesModel, contentOutputTTL, "text/turtle");
        ResponseOps.put(shortNamesModel, contentOutputNT, "application/n-triples");
    }
}

