/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.atlas.web.TypedOutputStream;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_REST;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.RiotWriter;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class REST_Quads
extends SPARQL_REST {
    static int counter = 0;

    public REST_Quads(boolean verbose) {
        super(verbose);
    }

    @Override
    protected void validate(HttpServletRequest request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(SPARQL_REST.HttpActionREST action) {
        ServletOutputStream output;
        MediaType mediaType = HttpAction.contentNegotationQuads(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            REST_Quads.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream(output, mediaType);
        Lang lang = WebContent.contentTypeToLang(mediaType.getContentType());
        if (lang == null) {
            lang = RDFLanguages.TRIG;
        }
        if (action.verbose) {
            log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        if (!RDFLanguages.isQuads(lang)) {
            REST_Quads.errorBadRequest("Not a quads format: " + mediaType);
        }
        action.beginRead();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            if (lang == RDFLanguages.NQUADS) {
                RiotWriter.writeNQuads((OutputStream)out, dsg);
            } else if (lang == RDFLanguages.TRIG) {
                REST_Quads.errorBadRequest("TriG - Not implemented (yet) : " + mediaType);
            } else {
                REST_Quads.errorBadRequest("No handled: " + mediaType);
            }
            REST_Quads.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(SPARQL_REST.HttpActionREST action) {
        action.response.setHeader("Allow", "GET, HEAD, OPTIONS");
        action.response.setHeader("Content-Length", "0");
        REST_Quads.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHead(SPARQL_REST.HttpActionREST action) {
        action.beginRead();
        try {
            MediaType mediaType = HttpAction.contentNegotationQuads(action);
            REST_Quads.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(SPARQL_REST.HttpActionREST action) {
        MediaType mediaType;
        Lang lang;
        if (!action.getDatasetRef().allowDatasetUpdate) {
            REST_Quads.errorMethodNotAllowed("POST");
        }
        boolean gspMode = Fuseki.graphStoreProtocolPostCreate;
        String x = action.request.getContentType();
        if (x == null) {
            REST_Quads.errorBadRequest("Content-type required for data format");
        }
        if ((lang = WebContent.contentTypeToLang((mediaType = MediaType.create(x)).getContentType())) == null) {
            lang = RDFLanguages.TRIG;
        }
        if (action.verbose) {
            log.info(String.format("[%d]   Post: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        if (RDFLanguages.isQuads(lang)) {
            this.doPostQuads(action, lang);
        } else if (gspMode && RDFLanguages.isTriples(lang)) {
            this.doPostTriplesGSP(action, lang);
        } else if (RDFLanguages.isTriples(lang)) {
            this.doPostTriples(action, lang);
        } else {
            REST_Quads.errorBadRequest("Not a triples or quads format: " + mediaType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostQuads(SPARQL_REST.HttpActionREST action, Lang lang) {
        action.beginWrite();
        try {
            String name = action.request.getRequestURL().toString();
            DatasetGraph dsg = action.getActiveDSG();
            StreamRDF dest = StreamRDFLib.dataset(dsg);
            LangRIOT parser = RiotReader.createParser(action.request.getInputStream(), lang, name, dest);
            parser.parse();
            action.commit();
            REST_Quads.success(action);
        }
        catch (IOException ex) {
            action.abort();
        }
        finally {
            action.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostTriples(SPARQL_REST.HttpActionREST action, Lang lang) {
        action.beginWrite();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            String name = action.request.getRequestURL().toString();
            Graph g = dsg.getDefaultGraph();
            StreamRDF dest = StreamRDFLib.graph(g);
            LangRIOT parser = RiotReader.createParser(action.request.getInputStream(), lang, name, dest);
            parser.parse();
            action.commit();
            REST_Quads.success(action);
        }
        catch (IOException ex) {
            action.abort();
        }
        finally {
            action.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPostTriplesGSP(SPARQL_REST.HttpActionREST action, Lang lang) {
        action.beginWrite();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            String name = action.request.getRequestURL().toString();
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            name = name + ++counter;
            Node gn = Node.createURI(name);
            Graph g = dsg.getGraph(gn);
            StreamRDF dest = StreamRDFLib.graph(g);
            LangRIOT parser = RiotReader.createParser(action.request.getInputStream(), lang, name, dest);
            parser.parse();
            log.info(String.format("[%d] Location: %s", action.id, name));
            action.response.setHeader("Location", name);
            action.commit();
            REST_Quads.successCreated(action);
        }
        catch (IOException ex) {
            action.abort();
        }
        finally {
            action.endWrite();
        }
    }

    @Override
    protected void doDelete(SPARQL_REST.HttpActionREST action) {
        REST_Quads.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doPut(SPARQL_REST.HttpActionREST action) {
        REST_Quads.errorMethodNotAllowed("PUT");
    }

    @Override
    protected void doPatch(SPARQL_REST.HttpActionREST action) {
        REST_Quads.errorMethodNotAllowed("PATCH");
    }
}

