/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DumpServlet
extends HttpServlet {
    private static final long serialVersionUID = 99L;

    @Override
    public void init() {
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            PrintWriter out = resp.getWriter();
            resp.setContentType("text/html");
            String now2 = new Date().toString();
            out.println("<html>");
            out.println("<head>");
            out.println("<Title>Dump @ " + now2 + "</Title>");
            out.println("<meta CONTENT=now HTTP-EQUIV=expires>");
            out.println("</head>");
            out.println("<body>");
            out.println("<pre>");
            out.println("Dump : " + now2);
            out.println();
            out.println("==== Request");
            out.println();
            out.print(DumpServlet.dumpRequest(req));
            out.println();
            out.println(">>>> Body");
            out.println();
            DumpServlet.printBody(out, req);
            out.println("<<<< Body");
            out.println("==== ServletContext");
            out.println();
            out.print(this.dumpServletContext());
            out.println();
            out.println("==== Environment");
            out.println();
            out.print(DumpServlet.dumpEnvironment());
            out.println();
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String dumpRequest(HttpServletRequest req) {
        try {
            String value;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Method:                 " + req.getMethod());
            pw.println("getContentLength:       " + Integer.toString(req.getContentLength()));
            pw.println("getContentType:         " + req.getContentType());
            pw.println("getRequestURI:          " + req.getRequestURI());
            pw.println("getRequestURL:          " + req.getRequestURL());
            pw.println("getContextPath:         " + req.getContextPath());
            pw.println("getServletPath:         " + req.getServletPath());
            pw.println("getPathInfo:            " + req.getPathInfo());
            pw.println("getPathTranslated:      " + req.getPathTranslated());
            pw.println("getQueryString:         " + req.getQueryString());
            pw.println("getProtocol:            " + req.getProtocol());
            pw.println("getScheme:              " + req.getScheme());
            pw.println("getServerName:          " + req.getServerName());
            pw.println("getServerPort:          " + req.getServerPort());
            pw.println("getRemoteUser:          " + req.getRemoteUser());
            pw.println("getRemoteAddr:          " + req.getRemoteAddr());
            pw.println("getRemoteHost:          " + req.getRemoteHost());
            pw.println("getRequestedSessionId:  " + req.getRequestedSessionId());
            Cookie[] c = req.getCookies();
            if (c == null) {
                pw.println("getCookies:            <none>");
            } else {
                for (int i = 0; i < c.length; ++i) {
                    pw.println("Cookie:        " + c[i].getName());
                    pw.println("    value:     " + c[i].getValue());
                    pw.println("    version:   " + c[i].getVersion());
                    pw.println("    comment:   " + c[i].getComment());
                    pw.println("    domain:    " + c[i].getDomain());
                    pw.println("    maxAge:    " + c[i].getMaxAge());
                    pw.println("    path:      " + c[i].getPath());
                    pw.println("    secure:    " + c[i].getSecure());
                    pw.println();
                }
            }
            Enumeration<String> en = req.getHeaderNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                value = req.getHeader(name);
                pw.println("Head: " + name + " = " + value);
            }
            Enumeration<String> en2 = req.getAttributeNames();
            if (en2.hasMoreElements()) {
                pw.println();
            }
            while (en2.hasMoreElements()) {
                String name = en2.nextElement();
                value = req.getAttribute(name).toString();
                pw.println("Attr: " + name + " = " + value);
            }
            Enumeration<Locale> en3 = req.getLocales();
            if (en3.hasMoreElements()) {
                pw.println();
            }
            while (en3.hasMoreElements()) {
                String name = en3.nextElement().toString();
                pw.println("Locale: " + name);
            }
            pw.println();
            pw.close();
            sw.close();
            return sw.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static void printBody(PrintWriter pw, HttpServletRequest req) throws IOException {
        String x;
        BufferedReader in = req.getReader();
        if (req.getContentLength() > 0) {
            in.mark(req.getContentLength() + 2);
        } else {
            in.mark(102400);
        }
        while ((x = in.readLine()) != null) {
            x = x.replaceAll("&", "&amp;");
            x = x.replaceAll("<", "&lt;");
            x = x.replaceAll(">", "&gt;");
            pw.println(x);
        }
        try {
            in.reset();
        }
        catch (IOException e2) {
            System.out.println("DumpServlet: Reset of content failed: " + e2);
        }
    }

    public static String dumpEnvironment() {
        Properties properties = System.getProperties();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Enumeration<Object> en = properties.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            pw.println(key + ": '" + properties.getProperty(key) + "'");
        }
        pw.println();
        pw.close();
        try {
            sw.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return sw.toString();
    }

    public String dumpServletContext() {
        String key;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ServletContext sc = this.getServletContext();
        pw.println("majorVersion: '" + sc.getMajorVersion() + "'");
        pw.println("minorVersion: '" + sc.getMinorVersion() + "'");
        pw.println("contextName:  '" + sc.getServletContextName() + "'");
        pw.println("servletInfo:  '" + this.getServletInfo() + "'");
        pw.println("serverInfo:  '" + sc.getServerInfo() + "'");
        Enumeration<String> en = sc.getInitParameterNames();
        if (en != null) {
            pw.println("initParameters: ");
            while (en.hasMoreElements()) {
                key = en.nextElement();
                pw.println(key + ": '" + sc.getInitParameter(key) + "'");
            }
        }
        if ((en = sc.getAttributeNames()) != null) {
            pw.println("attributes: ");
            while (en.hasMoreElements()) {
                key = en.nextElement();
                pw.println(key + ": '" + sc.getAttribute(key) + "'");
            }
        }
        pw.println();
        pw.close();
        try {
            sw.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return sw.toString();
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doGet(req, resp);
    }

    @Override
    public String getServletInfo() {
        return "Dump";
    }
}

