/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.system.IRIResolver;

public class FusekiVocab {
    public static String NS = "http://jena.apache.org/fuseki#";
    public static final Resource tServer = FusekiVocab.resource("Server");
    public static final Property pServices = FusekiVocab.property("services");
    public static final Property pServiceName = FusekiVocab.property("name");
    public static final Property pServiceQueryEP = FusekiVocab.property("serviceQuery");
    public static final Property pServiceUpdateEP = FusekiVocab.property("serviceUpdate");
    public static final Property pServiceUploadEP = FusekiVocab.property("serviceUpload");
    public static final Property pServiceReadWriteGraphStoreEP = FusekiVocab.property("serviceReadWriteGraphStore");
    public static final Property pServiceReadgraphStoreEP = FusekiVocab.property("serviceReadGraphStore");
    public static final Property pAllowTimeoutOverride = FusekiVocab.property("allowTimeoutOverride");
    public static final Property pMaximumTimeoutOverride = FusekiVocab.property("maximumTimeoutOverride");

    private static Resource resource(String localname2) {
        return ResourceFactory.createResource(FusekiVocab.iri(localname2));
    }

    private static Property property(String localname2) {
        return ResourceFactory.createProperty(FusekiVocab.iri(localname2));
    }

    private static String iri(String localname2) {
        String uri = NS + localname2;
        IRI iri2 = IRIResolver.parseIRI(uri);
        if (iri2.hasViolation(true)) {
            throw new FusekiException("Bad IRI: " + iri2);
        }
        if (!iri2.isAbsolute()) {
            throw new FusekiException("Bad IRI: " + iri2);
        }
        return uri;
    }
}

