/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.sparql.util.Convert;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;

public class FusekiLib {
    private static Map<Lang, String> mapLangToWriterName = new HashMap<Lang, String>();
    private static Model dummy;

    public static MediaType contentType(HttpServletRequest request) {
        String x = request.getHeader("Content-Type");
        if (x == null) {
            return null;
        }
        return MediaType.create(x);
    }

    public static RDFWriter chooseWriter(Lang lang) {
        String name;
        if (lang == null) {
            lang = RDFLanguages.RDFXML;
        }
        if ((name = mapLangToWriterName.get(lang)) == null) {
            throw new RiotException("Not a triples language: " + lang);
        }
        return dummy.getWriter(name);
    }

    static String fmtRequest(HttpServletRequest request) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm(request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm(tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static MultiMap<String, String> parseQueryString(HttpServletRequest req) {
        MultiMap<String, String> map = MultiMap.createMapList();
        if (req.getQueryString() != null) {
            String[] params = req.getQueryString().split("&");
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put(name, value);
            }
        }
        return map;
    }

    public static String safeParameter(HttpServletRequest request, String pName) {
        String value = request.getParameter(pName);
        value = StringUtils.replaceChars(value, "\r", "");
        value = StringUtils.replaceChars(value, "\n", "");
        return value;
    }

    static {
        mapLangToWriterName.put(RDFLanguages.N3, "N3");
        mapLangToWriterName.put(RDFLanguages.RDFJSON, "RDF/JSON");
        mapLangToWriterName.put(RDFLanguages.TURTLE, "TURTLE");
        mapLangToWriterName.put(RDFLanguages.NTRIPLES, "N-TRIPLES");
        mapLangToWriterName.put(RDFLanguages.RDFXML, "RDF/XML");
        dummy = ModelFactory.createDefaultModel();
    }
}

