/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.MappingRegistry;
import com.hp.hpl.jena.tdb.TDB;
import org.apache.jena.fuseki.server.SPARQLServer;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.stream.LocatorURL;
import org.apache.jena.riot.stream.StreamManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fuseki {
    public static String PATH = "org.apache.jena.fuseki";
    public static String FusekiIRI = "http://jena.apache.org/Fuseki";
    public static String FusekiHomeEnv = "FUSEKI_HOME";
    public static String FusekiSymbolIRI = "http://jena.apache.org/fuseki#";
    public static String PagesStatic = "pages";
    public static boolean graphStoreProtocolPostCreate = false;
    private static String metadataLocation = "org/apache/jena/fuseki/fuseki-properties.xml";
    private static Metadata metadata = Fuseki.initMetadata();
    public static final String NAME = "Fuseki";
    public static final String VERSION = metadata.get(PATH + ".version", "development");
    public static final String BUILD_DATE = metadata.get(PATH + ".build.datetime", "unknown");
    public static final String serverHttpName = "Fuseki (" + VERSION + ")";
    public static final String requestLogName = PATH + ".Fuseki";
    public static final Logger requestLog = LoggerFactory.getLogger(requestLogName);
    public static final String serverLogName = PATH + ".Server";
    public static final Logger serverLog = LoggerFactory.getLogger(serverLogName);
    public static final String configLogName = PATH + ".Config";
    public static final Logger configLog = LoggerFactory.getLogger(configLogName);
    public static final StreamManager webStreamManager = new StreamManager();
    private static boolean initialized;
    private static SPARQLServer server;

    private static Metadata initMetadata() {
        Metadata m = new Metadata();
        m.addMetadata(metadataLocation);
        return m;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ARQ.init();
        SystemInfo sysInfo = new SystemInfo(FusekiIRI, VERSION, BUILD_DATE);
        ARQMgt.register(PATH + ".system:type=SystemInfo", sysInfo);
        SystemARQ.registerSubSystem(sysInfo);
        RIOT.init();
        TDB.init();
        MappingRegistry.addPrefixMapping("fuseki", FusekiSymbolIRI);
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    public static void setServer(SPARQLServer _server) {
        server = _server;
    }

    public static SPARQLServer getServer() {
        return server;
    }

    static {
        webStreamManager.addLocator(new LocatorURL());
        initialized = false;
        Fuseki.init();
    }
}

