/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.MediaType;

public class TypedOutputStream
extends FilterOutputStream {
    private final MediaType mediaType;

    public TypedOutputStream(OutputStream out) {
        this(out, null);
    }

    public TypedOutputStream(OutputStream out, MediaType mediaType) {
        super(out);
        this.mediaType = mediaType;
    }

    public TypedOutputStream(OutputStream out, String mediaType, String charset) {
        this(out, MediaType.create(mediaType, charset));
    }

    public String getMediaType() {
        return this.mediaType.getContentType();
    }

    public String getCharset() {
        return this.mediaType.getCharset();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }
}

