/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.recordbuffer;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.page.PageBlockMgr;
import com.hp.hpl.jena.tdb.base.record.RecordException;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordbuffer.RecordBufferPage;
import java.nio.ByteBuffer;

public class RecordBufferPageMgr
extends PageBlockMgr<RecordBufferPage> {
    public RecordBufferPageMgr(RecordFactory factory, BlockMgr blockMgr) {
        super(null, blockMgr);
        Block2RecordBufferPage conv = new Block2RecordBufferPage(factory);
        super.setConverter(conv);
    }

    public RecordBufferPage create() {
        return (RecordBufferPage)super.create(BlockType.RECORD_BLOCK);
    }

    public RecordBufferPage getReadIterator(int id) {
        Block block = this.blockMgr.getReadIterator(id);
        RecordBufferPage page = (RecordBufferPage)this.pageFactory.fromBlock(block);
        return page;
    }

    public static class Block2RecordBufferPage
    implements BlockConverter<RecordBufferPage> {
        private RecordFactory factory;

        public Block2RecordBufferPage(RecordFactory factory) {
            this.factory = factory;
        }

        @Override
        public RecordBufferPage createFromBlock(Block block, BlockType blkType) {
            if (blkType != BlockType.RECORD_BLOCK) {
                throw new RecordException("Not RECORD_BLOCK: " + blkType);
            }
            RecordBufferPage rb = RecordBufferPage.createBlank(block, this.factory);
            return rb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RecordBufferPage fromBlock(Block block) {
            Block block2 = block;
            synchronized (block2) {
                RecordBufferPage rb = RecordBufferPage.format(block, this.factory);
                return rb;
            }
        }

        @Override
        public Block toBlock(RecordBufferPage rbp) {
            int count = rbp.getRecordBuffer().size();
            ByteBuffer bb = rbp.getBackingBlock().getByteBuffer();
            bb.putInt(0, rbp.getCount());
            bb.putInt(4, rbp.getLink());
            return rbp.getBackingBlock();
        }
    }
}

