/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;

public class CSVInputIterator
extends QueryIteratorBase {
    private BufferedReader reader;
    private BindingMap binding;
    private int expectedItems;
    private List<Var> vars;
    private long lineNum = 1L;

    public CSVInputIterator(BufferedReader reader, List<Var> vars) {
        this.reader = reader;
        this.expectedItems = vars.size();
        this.vars = vars;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println("CSVInputIterator");
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.reader != null) {
            if (this.binding == null) {
                return this.parseNextBinding();
            }
            return true;
        }
        return false;
    }

    private boolean parseNextBinding() {
        String line;
        try {
            line = this.reader.readLine();
            if (line == null) {
                return false;
            }
            ++this.lineNum;
        }
        catch (IOException e2) {
            throw new QueryException("Error parsing CSV results - " + e2.getMessage());
        }
        if (line.isEmpty()) {
            if (this.expectedItems > 1) {
                throw new QueryException(String.format("Error Parsing CSV results at Line %d - The result row had 0/1 values when %d were expected", this.lineNum, this.expectedItems));
            }
            this.binding = BindingFactory.create();
            if (this.expectedItems == 1) {
                this.binding.add(this.vars.get(0), NodeConst.emptyString);
            }
            return true;
        }
        this.binding = this.parseLine(this.vars, line);
        return true;
    }

    private BindingMap parseLine(List<Var> vars, String line) {
        BindingMap binding = BindingFactory.create();
        ArrayList<String> terms = new ArrayList<String>();
        for (int idx = 0; idx < line.length(); ++idx) {
            char ch = line.charAt(idx);
            StringBuilder s = new StringBuilder();
            if (ch == '\"' || ch == '\'') {
                char qCh = ch;
                ++idx;
                while (idx < line.length()) {
                    ch = line.charAt(idx);
                    ++idx;
                    if (ch == qCh) break;
                    s.append(ch);
                }
                if (ch != qCh) {
                    throw new QueryException(String.format("Error Parsing CSV results at Line %d  - Unterminated quoted string", this.lineNum));
                }
                if (idx < line.length() && (ch = line.charAt(idx)) != ',') {
                    throw new QueryException(String.format("Error Parsing CSV results at Line %d - Expected comma after quote", this.lineNum));
                }
            } else {
                while (idx < line.length() && (ch = line.charAt(idx)) != ',') {
                    ++idx;
                    s.append(ch);
                }
            }
            terms.add(s.toString());
            if (ch != ',' || idx != line.length() - 1) continue;
            terms.add("");
            break;
        }
        if (terms.size() != vars.size()) {
            throw new QueryException(String.format("Error Parsing CSV results at Line %d - The result row '%s' has %d items when %d was expected", this.lineNum, line, terms.size(), vars.size()));
        }
        for (int i = 0; i < vars.size(); ++i) {
            binding.add(vars.get(i), Node.createLiteral((String)terms.get(i)));
        }
        return binding;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BindingMap b = this.binding;
        this.binding = null;
        return b;
    }

    @Override
    protected void closeIterator() {
        IO.close(this.reader);
        this.reader = null;
    }

    @Override
    protected void requestCancel() {
    }
}

