/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpGraph
extends Op1 {
    Node node;

    public OpGraph(Node node, Op pattern) {
        super(pattern);
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return "graph";
    }

    @Override
    public Op apply(Transform transform, Op op) {
        return transform.transform(this, op);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op newOp) {
        return new OpGraph(this.node, newOp);
    }

    @Override
    public int hashCode() {
        return this.node.hashCode() ^ this.getSubOp().hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpGraph)) {
            return false;
        }
        OpGraph opGraph = (OpGraph)other;
        if (!this.node.equals(opGraph.node)) {
            return false;
        }
        return this.getSubOp().equalTo(opGraph.getSubOp(), labelMap);
    }
}

