/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;

final class JenaHandler
extends ARPSaxErrorHandler
implements StatementHandler,
NamespaceHandler {
    private final PrefixMapping prefixMapping;
    protected int here = 0;
    private final Graph graph;

    public JenaHandler(Model m, RDFErrorHandler e2) {
        this(m.getGraph(), e2);
    }

    public JenaHandler(Graph g, Model m, RDFErrorHandler e2) {
        this(g, JenaHandler.modelToPrefixMapping(m), e2);
    }

    private JenaHandler(Graph graph, RDFErrorHandler e2) {
        this(graph, graph.getPrefixMapping(), e2);
    }

    private JenaHandler(Graph graph, PrefixMapping prefixMapping, RDFErrorHandler errorHandler) {
        super(errorHandler);
        this.graph = graph;
        this.prefixMapping = prefixMapping;
    }

    private static PrefixMapping modelToPrefixMapping(Model model) {
        return model == null ? PrefixMapping.Factory.create() : model.getGraph().getPrefixMapping();
    }

    public void useWith(ARPHandlers h) {
        h.setStatementHandler(this);
        h.setErrorHandler(this);
        h.setNamespaceHandler(this);
    }

    @Override
    public void statement(AResource subj, AResource pred, AResource obj) {
        try {
            Triple t = JenaReader.convert(subj, pred, obj);
            this.graph.add(t);
        }
        catch (JenaException e2) {
            this.errorHandler.error(e2);
        }
    }

    @Override
    public void statement(AResource subj, AResource pred, ALiteral lit) {
        try {
            Triple t = JenaReader.convert(subj, pred, lit);
            this.graph.add(t);
        }
        catch (JenaException e2) {
            this.errorHandler.error(e2);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (PrefixMappingImpl.isNiceURI(uri)) {
            this.prefixMapping.setNsPrefix(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }
}

