/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.iri.IRI;

public class ParameterizedSparqlString
implements PrefixMapping {
    private Model model = ModelFactory.createDefaultModel();
    private StringBuilder cmd = new StringBuilder();
    private String baseUri;
    private Map<String, Node> params = new HashMap<String, Node>();
    private PrefixMapping prefixes;

    public ParameterizedSparqlString(String command, QuerySolutionMap map, String base, PrefixMapping prefixes) {
        if (command != null) {
            this.cmd.append(command);
        }
        this.setParams(map);
        this.baseUri = base != null && !base.equals("") ? base : null;
        this.prefixes = new PrefixMappingImpl();
        if (prefixes != null) {
            this.prefixes.setNsPrefixes(prefixes);
        }
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map, String base) {
        this(command, map, base, null);
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map, PrefixMapping prefixes) {
        this(command, map, null, prefixes);
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map) {
        this(command, map, null, null);
    }

    public ParameterizedSparqlString(String command, String base, PrefixMapping prefixes) {
        this(command, null, base, prefixes);
    }

    public ParameterizedSparqlString(String command, PrefixMapping prefixes) {
        this(command, null, null, prefixes);
    }

    public ParameterizedSparqlString(String command, String base) {
        this(command, null, base, null);
    }

    public ParameterizedSparqlString(String command) {
        this(command, null, null, null);
    }

    public ParameterizedSparqlString(QuerySolutionMap map, PrefixMapping prefixes) {
        this(null, map, null, prefixes);
    }

    public ParameterizedSparqlString(QuerySolutionMap map) {
        this(null, map, null, null);
    }

    public ParameterizedSparqlString(PrefixMapping prefixes) {
        this(null, null, null, prefixes);
    }

    public ParameterizedSparqlString() {
        this("", null, null, null);
    }

    public void setCommandText(String command) {
        this.cmd = new StringBuilder();
        this.cmd.append(command);
    }

    public void append(String text) {
        this.cmd.append(text);
    }

    public void append(char c) {
        this.cmd.append(c);
    }

    public void append(boolean b) {
        this.cmd.append(b);
    }

    public void append(double d) {
        this.cmd.append(d);
    }

    public void append(float f) {
        this.cmd.append(f);
    }

    public void append(int i) {
        this.cmd.append(i);
    }

    public void append(long l) {
        this.cmd.append(l);
    }

    public void append(Object obj) {
        this.cmd.append(obj);
    }

    public void appendNode(Node n) {
        SerializationContext context = new SerializationContext(this.prefixes);
        context.setBaseIRI(this.baseUri);
        this.cmd.append(FmtUtils.stringForNode(n, context));
    }

    public void appendNode(RDFNode n) {
        this.appendNode(n.asNode());
    }

    public void appendIri(String uri) {
        this.cmd.append(FmtUtils.stringForURI(uri));
    }

    public void appendIri(IRI iri2) {
        this.appendIri(iri2.toString());
    }

    public void appendLiteral(String value) {
        this.appendNode(NodeFactory.createLiteralNode(value, null, null));
    }

    public void appendLiteral(String value, String lang) {
        this.appendNode(NodeFactory.createLiteralNode(value, lang, null));
    }

    public void appendLiteral(String value, RDFDatatype datatype) {
        this.appendNode(NodeFactory.createLiteralNode(value, null, datatype.getURI()));
    }

    public void appendLiteral(boolean b) {
        this.appendNode(this.model.createTypedLiteral(b));
    }

    public void appendLiteral(int i) {
        this.appendNode(NodeFactory.intToNode(i));
    }

    public void appendLiteral(long l) {
        this.appendNode(NodeFactory.intToNode(l));
    }

    public void appendLiteral(float f) {
        this.appendNode(this.model.createTypedLiteral(f));
    }

    public void appendLiteral(double d) {
        this.appendNode(this.model.createTypedLiteral(d));
    }

    public void appendLiteral(Calendar dt) {
        this.appendNode(this.model.createTypedLiteral(dt));
    }

    public String getCommandText() {
        return this.cmd.toString();
    }

    public void setBaseUri(String base) {
        this.baseUri = base;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setParams(QuerySolutionMap map) {
        if (map != null) {
            Iterator<String> iter = map.varNames();
            while (iter.hasNext()) {
                String var = iter.next();
                this.setParam(var, map.get(var).asNode());
            }
        }
    }

    public void setParam(String var, Node n) {
        if (var == null) {
            throw new IllegalArgumentException("var cannot be null");
        }
        if (var.startsWith("?") || var.startsWith("$")) {
            var = var.substring(1);
        }
        if (n != null) {
            this.params.put(var, n);
        } else {
            this.params.remove(var);
        }
    }

    public void setParam(String var, RDFNode n) {
        this.setParam(var, n.asNode());
    }

    public void setIri(String var, String iri2) {
        this.setParam(var, this.model.createResource(iri2));
    }

    public void setIri(String var, IRI iri2) {
        this.setIri(var, iri2.toString());
    }

    public void setIri(String var, URL url) {
        this.setIri(var, url.toString());
    }

    public void setLiteral(String var, Literal lit) {
        this.setParam(var, lit.asNode());
    }

    public void setLiteral(String var, String value) {
        this.setParam(var, NodeFactory.createLiteralNode(value, null, null));
    }

    public void setLiteral(String var, String value, String lang) {
        this.setParam(var, NodeFactory.createLiteralNode(value, lang, null));
    }

    public void setLiteral(String var, String value, RDFDatatype datatype) {
        this.setParam(var, this.model.createTypedLiteral(value, datatype));
    }

    public void setLiteral(String var, boolean value) {
        this.setParam(var, this.model.createTypedLiteral(value));
    }

    public void setLiteral(String var, int i) {
        this.setParam(var, NodeFactory.intToNode(i));
    }

    public void setLiteral(String var, long l) {
        this.setParam(var, NodeFactory.intToNode(l));
    }

    public void setLiteral(String var, float f) {
        this.setParam(var, NodeFactory.floatToNode(f));
    }

    public void setLiteral(String var, double d) {
        this.setParam(var, this.model.createTypedLiteral(d));
    }

    public void setLiteral(String var, Calendar dt) {
        this.setParam(var, this.model.createTypedLiteral(dt));
    }

    public Node getParam(String var) {
        return this.params.get(var);
    }

    public Iterator<String> getVars() {
        return this.params.keySet().iterator();
    }

    public void clearParam(String var) {
        this.params.remove(var);
    }

    public void clearParams() {
        this.params.clear();
    }

    public String toString() {
        String command = this.cmd.toString();
        SerializationContext context = new SerializationContext(this.prefixes);
        context.setBaseIRI(this.baseUri);
        for (String var : this.params.keySet()) {
            Pattern p = Pattern.compile("([?$]" + var + ")([^\\w]|$)");
            command = p.matcher(command).replaceAll(Matcher.quoteReplacement(FmtUtils.stringForNode(this.params.get(var), context)) + "$2");
        }
        StringBuilder finalCmd = new StringBuilder();
        if (this.baseUri != null) {
            finalCmd.append("BASE ");
            finalCmd.append(FmtUtils.stringForURI(this.baseUri, null, null));
            finalCmd.append('\n');
        }
        for (String prefix : this.prefixes.getNsPrefixMap().keySet()) {
            finalCmd.append("PREFIX ");
            finalCmd.append(prefix);
            finalCmd.append(": ");
            finalCmd.append(FmtUtils.stringForURI(this.prefixes.getNsPrefixURI(prefix), null, null));
            finalCmd.append('\n');
        }
        finalCmd.append(command);
        return finalCmd.toString();
    }

    public Query asQuery() throws QueryException {
        return QueryFactory.create(this.toString());
    }

    public UpdateRequest asUpdate() {
        return UpdateFactory.create(this.toString());
    }

    public ParameterizedSparqlString copy() {
        return this.copy(true, true, true);
    }

    public ParameterizedSparqlString copy(boolean copyParams) {
        return this.copy(copyParams, true, true);
    }

    public ParameterizedSparqlString copy(boolean copyParams, boolean copyBase, boolean copyPrefixes) {
        ParameterizedSparqlString copy = new ParameterizedSparqlString(this.cmd.toString(), null, copyBase ? this.baseUri : null, copyPrefixes ? this.prefixes : null);
        if (copyParams) {
            Iterator<String> vars = this.getVars();
            while (vars.hasNext()) {
                String var = vars.next();
                copy.setParam(var, this.getParam(var));
            }
        }
        return copy;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        return this.prefixes.setNsPrefix(prefix, uri);
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        return this.prefixes.removeNsPrefix(prefix);
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.prefixes.setNsPrefixes(other);
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        return this.prefixes.setNsPrefixes(map);
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        return this.prefixes.withDefaultMappings(map);
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.prefixes.getNsPrefixURI(prefix);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.prefixes.getNsURIPrefix(uri);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.prefixes.getNsPrefixMap();
    }

    @Override
    public String expandPrefix(String prefixed) {
        return this.prefixes.expandPrefix(prefixed);
    }

    @Override
    public String shortForm(String uri) {
        return this.prefixes.shortForm(uri);
    }

    @Override
    public String qnameFor(String uri) {
        return this.prefixes.qnameFor(uri);
    }

    @Override
    public PrefixMapping lock() {
        return this.prefixes.lock();
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.prefixes.samePrefixMappingAs(other);
    }
}

