/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.selectitems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.omnifaces.el.ScopedRunner;
import org.omnifaces.model.ExtendedSelectItem;
import org.omnifaces.util.Utils;
import org.omnifaces.util.selectitems.SelectItemsBuilder;

public final class SelectItemsCollector {
    private static final String ERROR_UNKNOWN_SELECT_TYPE = "A value expression of type '%s' is disallowed for a select item";

    private SelectItemsCollector() {
    }

    public static List<SelectItem> collectFromParent(FacesContext context2, UIComponent parent) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UIComponent child : parent.getChildren()) {
            UISelectItems uiSelectItems;
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                selectItems.add(SelectItemsCollector.getFromUISelectItem(uiSelectItem));
                continue;
            }
            if (!(child instanceof UISelectItems) || (uiSelectItems = (UISelectItems)child).getValue() == null) continue;
            selectItems.addAll(SelectItemsCollector.collectFromUISelectItems(context2, uiSelectItems));
        }
        return selectItems;
    }

    private static SelectItem getFromUISelectItem(UISelectItem uiSelectItem) {
        Object value = uiSelectItem.getValue();
        if (value instanceof SelectItem) {
            return (SelectItem)value;
        }
        if (value == null) {
            return new ExtendedSelectItem(uiSelectItem);
        }
        throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_SELECT_TYPE, value.getClass().toString()));
    }

    private static Collection<SelectItem> collectFromUISelectItems(FacesContext context2, UISelectItems uiSelectItems) {
        Object value = uiSelectItems.getValue();
        if (value instanceof SelectItem) {
            return Collections.singleton((SelectItem)value);
        }
        if (value instanceof Object[]) {
            return SelectItemsCollector.collectFromUISelectItemsIterator(context2, uiSelectItems, Arrays.asList((Object[])value));
        }
        if (value instanceof Iterable) {
            return SelectItemsCollector.collectFromUISelectItemsIterator(context2, uiSelectItems, (Iterable)value);
        }
        if (value instanceof Map) {
            return SelectItemsBuilder.fromMap((Map)value);
        }
        throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_SELECT_TYPE, value.getClass().toString()));
    }

    public static List<SelectItem> collectFromUISelectItemsIterator(FacesContext facesContext, UISelectItems uiSelectItems, Iterable<?> items) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        Map attributes = uiSelectItems.getAttributes();
        String var = (String)attributes.get("var");
        ScopedRunner scopedRunner = new ScopedRunner(facesContext);
        for (Object item : items) {
            if (item instanceof SelectItem) {
                selectItems.add((SelectItem)item);
                continue;
            }
            if (!Utils.isEmpty(var)) {
                scopedRunner.with(var, item);
            }
            scopedRunner.invoke(() -> {
                Object itemValue = SelectItemsCollector.getItemValue(attributes, item);
                Object noSelectionValue = attributes.get("noSelectionValue");
                boolean itemValueIsNoSelectionValue = noSelectionValue != null && noSelectionValue.equals(itemValue);
                selectItems.add(new SelectItem(itemValue, SelectItemsCollector.getItemLabel(attributes, itemValue), SelectItemsCollector.getItemDescription(attributes), SelectItemsCollector.getBooleanAttribute(attributes, "itemDisabled", false), SelectItemsCollector.getBooleanAttribute(attributes, "itemLabelEscaped", true), SelectItemsCollector.getBooleanAttribute(attributes, "noSelectionOption", false) || itemValueIsNoSelectionValue));
            });
        }
        return selectItems;
    }

    private static Object getItemValue(Map<String, Object> attributes, Object item) {
        Object itemValue = attributes.get("itemValue");
        if (itemValue == null) {
            itemValue = item;
        }
        return itemValue;
    }

    private static String getItemLabel(Map<String, Object> attributes, Object itemValue) {
        Object itemLabelObj = attributes.get("itemLabel");
        String itemLabel = itemLabelObj != null ? itemLabelObj.toString() : itemValue.toString();
        return itemLabel;
    }

    private static String getItemDescription(Map<String, Object> attributes) {
        Object itemDescriptionObj = attributes.get("itemDescription");
        String itemDescription = null;
        if (itemDescriptionObj != null) {
            itemDescription = itemDescriptionObj.toString();
        }
        return itemDescription;
    }

    private static boolean getBooleanAttribute(Map<String, Object> attributes, String key, boolean defaultValue) {
        Object valueObj = attributes.get(key);
        boolean value = defaultValue;
        if (valueObj != null) {
            value = Boolean.parseBoolean(valueObj.toString());
        }
        return value;
    }
}

