/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.cache;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.omnifaces.util.cache.Cache;
import org.omnifaces.util.cache.CacheEntry;

public abstract class TimeToLiveCache
implements Cache {
    private static final long serialVersionUID = 1L;
    private final Integer defaultTimeToLive;
    private Map<String, CacheEntry> cacheStore;

    protected TimeToLiveCache(Integer defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    @Override
    public String get(String key) {
        return (String)((Object)this.getObject(key));
    }

    @Override
    public Serializable getObject(String key) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry != null) {
            if (entry.isValid()) {
                return entry.getValue();
            }
            this.cacheStore.remove(key);
        }
        return null;
    }

    @Override
    public void put(String key, String value) {
        if (this.defaultTimeToLive != null) {
            this.put(key, value, this.defaultTimeToLive);
        } else {
            this.put(key, value, -1);
        }
    }

    @Override
    public void put(String key, String value, int timeToLive) {
        this.putObject(key, (Serializable)((Object)value), timeToLive);
    }

    @Override
    public void putObject(String key, Serializable value, int timeToLive) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry == null || !entry.isValid()) {
            this.cacheStore.put(key, new CacheEntry(value, this.timeToLiveToDate(timeToLive)));
        } else {
            entry.setValue(value);
            entry.setValidTill(this.timeToLiveToDate(timeToLive));
        }
    }

    @Override
    public void putAttribute(String key, String name, Serializable value, int timeToLive) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry == null || !entry.isValid()) {
            entry = new CacheEntry(null, this.timeToLiveToDate(timeToLive));
            this.cacheStore.put(key, entry);
        }
        entry.getAttributes().put(name, value);
    }

    @Override
    public Serializable getAttribute(String key, String name) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry != null) {
            if (entry.isValid()) {
                return entry.getAttributes().get(name);
            }
            this.cacheStore.remove(key);
        }
        return null;
    }

    @Override
    public void remove(String key) {
        this.cacheStore.remove(key);
    }

    @Override
    public void clear() {
        this.cacheStore.clear();
    }

    protected void setCacheStore(Map<String, CacheEntry> cacheStore) {
        this.cacheStore = cacheStore;
    }

    private Date timeToLiveToDate(int timeToLive) {
        if (timeToLive != -1) {
            return new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeToLive));
        }
        return null;
    }
}

