/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.cache;

import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.omnifaces.util.cache.Cache;
import org.omnifaces.util.cache.CacheProvider;
import org.omnifaces.util.cache.DefaultCacheProvider;

public final class CacheFactory {
    public static final String CACHE_PROVIDER_PARAM_NAME = "org.omnifaces.cacheprovider";
    private static final CacheProvider DEFAULT_PROVIDER = new DefaultCacheProvider();

    private CacheFactory() {
    }

    public static Cache getCache(FacesContext context2, String scope) {
        return CacheFactory.getCacheProvider(context2).getCache(context2, scope);
    }

    public static CacheProvider getCacheProvider(ServletContext servletContext) {
        return (CacheProvider)servletContext.getAttribute(CACHE_PROVIDER_PARAM_NAME);
    }

    public static void setCacheProvider(CacheProvider cacheProvider, ServletContext servletContext) {
        servletContext.setAttribute(CACHE_PROVIDER_PARAM_NAME, (Object)cacheProvider);
    }

    public static CacheProvider getCacheProvider(FacesContext context2) {
        CacheProvider provider = (CacheProvider)context2.getExternalContext().getApplicationMap().get(CACHE_PROVIDER_PARAM_NAME);
        return provider != null ? provider : DEFAULT_PROVIDER;
    }

    public static CacheProvider getDefaultCacheProvider() {
        return DEFAULT_PROVIDER;
    }
}

