/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.component.validator.ValidateMultipleFields;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;

public class SkipValidators
extends TagHandler {
    private static final String UIINPUT_REQUIRED_PROPERTY = "required";
    private static final String UIINPUT_DISABLED_PROPERTY = "disabled";
    private static final String ERROR_INVALID_PARENT = "Parent component of o:skipValidators must be an instance of UICommand or ClientBehaviorHolder.";

    public SkipValidators(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context2, UIComponent parent) throws IOException {
        if (!(parent instanceof UICommand) && !(parent instanceof ClientBehaviorHolder)) {
            throw new IllegalStateException(ERROR_INVALID_PARENT);
        }
        FacesContext facesContext = context2.getFacesContext();
        if (!ComponentHandler.isNew((UIComponent)parent) || !facesContext.isPostback() || facesContext.getCurrentPhaseId() != PhaseId.RESTORE_VIEW) {
            return;
        }
        Events.subscribeToRequestAfterPhase(PhaseId.RESTORE_VIEW, () -> this.processSkipValidators(parent));
    }

    protected void processSkipValidators(UIComponent parent) {
        if (!Components.hasInvokedSubmit(parent)) {
            return;
        }
        SkipValidatorsEventListener listener = new SkipValidatorsEventListener();
        Events.subscribeToViewEvent(PreValidateEvent.class, listener);
        Events.subscribeToViewEvent(PostValidateEvent.class, listener);
    }

    static class SkipValidatorsEventListener
    implements SystemEventListener {
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private Map<String, Validator<?>[]> allValidators = new HashMap<String, Validator<?>[]>();

        SkipValidatorsEventListener() {
        }

        public boolean isListenerForSource(Object source) {
            return source instanceof UIInput || source instanceof ValidateMultipleFields;
        }

        public void processEvent(SystemEvent event) {
            UIComponent source = (UIComponent)event.getSource();
            if (source instanceof UIInput) {
                this.processEventForUIInput(event, (UIInput)source);
            } else if (source instanceof ValidateMultipleFields) {
                this.processEventForValidateMultipleFields(event, (ValidateMultipleFields)source);
            }
        }

        private void processEventForUIInput(SystemEvent event, UIInput input) {
            String clientId = input.getClientId();
            if (event instanceof PreValidateEvent) {
                ValueExpression requiredExpression = input.getValueExpression(SkipValidators.UIINPUT_REQUIRED_PROPERTY);
                if (requiredExpression != null) {
                    this.attributes.put(clientId, requiredExpression);
                    input.setValueExpression(SkipValidators.UIINPUT_REQUIRED_PROPERTY, Components.createValueExpression("#{false}", Boolean.class));
                } else {
                    this.attributes.put(clientId, input.isRequired());
                    input.setRequired(false);
                }
                Validator[] validators = input.getValidators();
                this.allValidators.put(clientId, validators);
                for (Validator validator : validators) {
                    input.removeValidator(validator);
                }
            } else if (event instanceof PostValidateEvent) {
                for (Validator<?> validator : this.allValidators.remove(clientId)) {
                    input.addValidator(validator);
                }
                Object requiredValue = this.attributes.remove(clientId);
                if (requiredValue instanceof ValueExpression) {
                    input.setValueExpression(SkipValidators.UIINPUT_REQUIRED_PROPERTY, (ValueExpression)requiredValue);
                } else {
                    input.setRequired(Boolean.TRUE.equals(requiredValue));
                }
            }
        }

        private void processEventForValidateMultipleFields(SystemEvent event, ValidateMultipleFields validator) {
            String clientId = validator.getClientId();
            if (event instanceof PreValidateEvent) {
                ValueExpression disabledExpression = validator.getValueExpression(SkipValidators.UIINPUT_DISABLED_PROPERTY);
                this.attributes.put(clientId, disabledExpression != null ? disabledExpression : Boolean.valueOf(validator.isDisabled()));
                validator.setDisabled(true);
            } else if (event instanceof PostValidateEvent) {
                Object disabledValue = this.attributes.remove(clientId);
                if (disabledValue instanceof ValueExpression) {
                    validator.setValueExpression(SkipValidators.UIINPUT_DISABLED_PROPERTY, (ValueExpression)disabledValue);
                } else {
                    validator.setDisabled(Boolean.TRUE.equals(disabledValue));
                }
            }
        }
    }
}

