/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.FunctionMapper;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.util.Facelets;

public class ImportFunctions
extends TagHandler {
    private static final Logger logger = Logger.getLogger(ImportFunctions.class.getName());
    private static final Map<String, Method> FUNCTIONS_CACHE = new ConcurrentHashMap<String, Method>();
    private static final String ERROR_MISSING_CLASS = "Cannot find type '%s' in classpath.";
    private static final String ERROR_INVALID_FUNCTION = "Type '%s' does not have the function '%s'.";
    private String varValue = Facelets.getStringLiteral(this.getAttribute("var"), "var");
    private TagAttribute typeAttribute = this.getRequiredAttribute("type");

    public ImportFunctions(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context2, UIComponent parent) throws IOException {
        String type = this.typeAttribute.getValue(context2);
        String var = this.varValue != null ? this.varValue : type.substring(type.lastIndexOf(46) + 1);
        FunctionMapper originalFunctionMapper = context2.getFunctionMapper();
        context2.setFunctionMapper((FunctionMapper)new ImportFunctionsMapper(originalFunctionMapper, var, ImportFunctions.toClass(type)));
    }

    static Class<?> toClass(String type) {
        try {
            return Class.forName(type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e2) {
            int i = type.lastIndexOf(46);
            if (i > 0) {
                try {
                    return ImportFunctions.toClass(new StringBuilder(type).replace(i, i + 1, "$").toString());
                }
                catch (Exception ignore) {
                    logger.log(Level.FINEST, "Ignoring thrown exception; previous exception will be rethrown instead.", ignore);
                }
            }
            throw new IllegalArgumentException(String.format(ERROR_MISSING_CLASS, type), e2);
        }
    }

    private static class ImportFunctionsMapper
    extends FunctionMapper {
        private FunctionMapper originalFunctionMapper;
        private String var;
        private Class<?> type;

        public ImportFunctionsMapper(FunctionMapper originalFunctionMapper, String var, Class<?> type) {
            this.originalFunctionMapper = originalFunctionMapper;
            this.var = var;
            this.type = type;
        }

        public Method resolveFunction(String prefix, String name) {
            if (this.var.equals(prefix)) {
                String key = this.type + "." + name;
                Method function = (Method)FUNCTIONS_CACHE.get(key);
                if (function == null) {
                    function = ImportFunctionsMapper.findMethod(this.type, name);
                    if (function == null) {
                        throw new IllegalArgumentException(String.format(ImportFunctions.ERROR_INVALID_FUNCTION, this.type.getName(), name));
                    }
                    FUNCTIONS_CACHE.put(key, function);
                }
                return function;
            }
            return this.originalFunctionMapper.resolveFunction(prefix, name);
        }

        private static Method findMethod(Class<?> cls, String name) {
            TreeSet<Method> methods = new TreeSet<Method>((m1, m2) -> Integer.valueOf(m1.getParameterCount()).compareTo(m2.getParameterCount()));
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.getName().equals(name) || !ImportFunctionsMapper.isPublicStaticNonVoid(method)) continue;
                methods.add(method);
            }
            return methods.isEmpty() ? null : (Method)methods.iterator().next();
        }

        private static boolean isPublicStaticNonVoid(Method method) {
            int modifiers = method.getModifiers();
            return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && method.getReturnType() != Void.TYPE;
        }
    }
}

