/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.taghandler.ImportFunctions;
import org.omnifaces.util.Facelets;
import org.omnifaces.util.MapWrapper;
import org.omnifaces.util.Utils;

public class ImportConstants
extends TagHandler {
    private static final Map<String, Map<String, Object>> CONSTANTS_CACHE = new ConcurrentHashMap<String, Map<String, Object>>();
    private static final String ERROR_FIELD_ACCESS = "Cannot access constant field '%s' of type '%s'.";
    private static final String ERROR_INVALID_CONSTANT = "Type '%s' does not have the constant '%s'.";
    private String varValue = Facelets.getStringLiteral(this.getAttribute("var"), "var");
    private TagAttribute typeAttribute = this.getRequiredAttribute("type");

    public ImportConstants(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context2, UIComponent parent) throws IOException {
        String var;
        String type = this.typeAttribute.getValue(context2);
        Map<String, Object> constants = CONSTANTS_CACHE.get(type);
        if (constants == null) {
            constants = ImportConstants.collectConstants(type);
            CONSTANTS_CACHE.put(type, constants);
        }
        if ((var = this.varValue) == null) {
            int innerClass = type.lastIndexOf(36);
            int outerClass = type.lastIndexOf(46);
            var = type.substring(Math.max(innerClass, outerClass) + 1);
        }
        context2.setAttribute(var, constants);
    }

    private static Map<String, Object> collectConstants(String type) {
        LinkedHashMap<String, Object> constants = new LinkedHashMap<String, Object>();
        for (Class<?> declaredType : ImportConstants.getDeclaredTypes(ImportFunctions.toClass(type))) {
            for (Field field : declaredType.getDeclaredFields()) {
                if (!ImportConstants.isPublicStaticFinal(field)) continue;
                try {
                    constants.putIfAbsent(field.getName(), field.get(null));
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException(String.format(ERROR_FIELD_ACCESS, type, field.getName()), e2);
                }
            }
        }
        return new ConstantsMap(constants, type);
    }

    private static Set<Class<?>> getDeclaredTypes(Class<?> type) {
        LinkedHashSet declaredTypes = new LinkedHashSet();
        declaredTypes.add(type);
        ImportConstants.fillAllSuperClasses(type, declaredTypes);
        new LinkedHashSet(declaredTypes).stream().forEach(declaredType -> ImportConstants.fillAllInterfaces(declaredType, declaredTypes));
        return Collections.unmodifiableSet(declaredTypes);
    }

    private static void fillAllSuperClasses(Class<?> type, Set<Class<?>> set) {
        Class<?> sc = type.getSuperclass();
        while (!Utils.isOneOf(sc, null, Object.class)) {
            set.add(sc);
            sc = sc.getSuperclass();
        }
    }

    private static void fillAllInterfaces(Class<?> type, Set<Class<?>> set) {
        for (Class<?> i : type.getInterfaces()) {
            if (!set.add(i)) continue;
            ImportConstants.fillAllInterfaces(i, set);
        }
    }

    private static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    private static class ConstantsMap
    extends MapWrapper<String, Object> {
        private static final long serialVersionUID = 1L;
        private String type;

        public ConstantsMap(Map<String, Object> map, String type) {
            super(Collections.unmodifiableMap(map));
            this.type = type;
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException(String.format(ImportConstants.ERROR_INVALID_CONSTANT, this.type, key));
            }
            return super.get(key);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.type.equals(((ConstantsMap)object).type);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.type.hashCode();
        }
    }
}

