/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceWrapper;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public class SourceMapResourceHandler
extends DefaultResourceHandler {
    public static final String PARAM_NAME_SOURCE_MAP_PATTERN = "org.omnifaces.SOURCE_MAP_RESOURCE_HANDLER_PATTERN";
    private static final Map<ResourceIdentifier, String> SOURCE_MAPS = new ConcurrentHashMap<ResourceIdentifier, String>();
    private static final String DEFAULT_SOURCE_MAP_PATTERN = "*.map";
    private static final String EXTENSION_JS = ".js";
    private static final String EXTENSION_CSS = ".css";
    private static final String HEADER_SOURCE_MAP = "SourceMap";
    private String sourceMapPattern = Faces.getInitParameterOrDefault("org.omnifaces.SOURCE_MAP_RESOURCE_HANDLER_PATTERN", "*.map");

    public SourceMapResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
    }

    @Override
    public Resource decorateResource(Resource resource, String resourceName, String libraryName) {
        if (resource == null) {
            return null;
        }
        final String sourceMap = SOURCE_MAPS.computeIfAbsent(new ResourceIdentifier(libraryName, resourceName), this::computeSourceMap);
        return super.decorateResource((Resource)(sourceMap.isEmpty() ? resource : new ResourceWrapper(resource){

            public Map<String, String> getResponseHeaders() {
                Map responseHeaders = super.getResponseHeaders();
                responseHeaders.put(SourceMapResourceHandler.HEADER_SOURCE_MAP, sourceMap);
                return responseHeaders;
            }
        }), resourceName, libraryName);
    }

    private String computeSourceMap(ResourceIdentifier resourceIdentifier) {
        Resource sourceMapResource;
        if (Utils.endsWithOneOf(resourceIdentifier.getName(), EXTENSION_JS, EXTENSION_CSS) && (sourceMapResource = this.createResource(this.sourceMapPattern.replace("*", resourceIdentifier.getName()), resourceIdentifier.getLibrary())) != null) {
            return sourceMapResource.getRequestPath();
        }
        return "";
    }
}

