/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.omnifaces.cdi.GraphicImageBean;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.el.MethodReference;
import org.omnifaces.resourcehandler.DynamicResource;
import org.omnifaces.util.Beans;
import org.omnifaces.util.BeansLocal;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;

public class GraphicResource
extends DynamicResource {
    private static final Logger logger = Logger.getLogger(GraphicResource.class.getName());
    private static final String DEFAULT_CONTENT_TYPE = "image";
    private static final Map<String, String> CONTENT_TYPES_BY_BASE64_HEADER = GraphicResource.createContentTypesByBase64Header();
    private static final Map<String, MethodReference> ALLOWED_METHODS = new ConcurrentHashMap<String, MethodReference>();
    private static final String[] EMPTY_PARAMS = new String[0];
    private static final Class<? extends Annotation>[] REQUIRED_ANNOTATION_TYPES = new Class[]{GraphicImageBean.class, javax.faces.bean.ApplicationScoped.class, ApplicationScoped.class};
    private static final Class<? extends Annotation>[] REQUIRED_RETURN_TYPES = new Class[]{InputStream.class, byte[].class};
    private static final AnnotationLiteral<Any> ANY = new AnnotationLiteral<Any>(){
        private static final long serialVersionUID = 1L;
    };
    private static final String ERROR_MISSING_METHOD = "@GraphicImageBean bean '%s' must have a method returning an InputStream or byte[].";
    private static final String ERROR_INVALID_LASTMODIFIED = "o:graphicImage 'lastModified' attribute must be an instance of Long or Date. Encountered an invalid value of '%s'.";
    private static final String ERROR_INVALID_TYPE = "o:graphicImage 'type' attribute must represent a valid file extension. Encountered an invalid value of '%s'.";
    private static final String ERROR_UNKNOWN_METHOD = "o:graphicImage 'value' attribute must refer an existing method. Encountered an unknown method of '%s'.";
    private static final String ERROR_INVALID_SCOPE = "o:graphicImage 'value' attribute must refer a @GraphicImageBean or @ApplicationScoped bean. Cannot find the right annotation on bean class '%s'.";
    private static final String ERROR_INVALID_RETURNTYPE = "o:graphicImage 'value' attribute must represent a method returning an InputStream or byte[]. Encountered an invalid return value of '%s'.";
    private static final String ERROR_INVALID_PARAMS = "o:graphicImage 'value' attribute must specify valid method parameters. Encountered invalid method parameters '%s'.";
    private String base64;
    private String[] params;

    public GraphicResource(Object content, String contentType) {
        super("", "omnifaces.graphic", contentType);
        this.base64 = GraphicResource.convertToBase64(content);
        if (contentType == null) {
            this.setContentType(GraphicResource.guessContentType(this.base64));
        } else if (!contentType.contains("/")) {
            this.setContentType(GraphicResource.getContentType("image." + contentType));
        }
    }

    public GraphicResource(String name, String[] params, Object lastModified) {
        super(name, "omnifaces.graphic", GraphicResource.getContentType(name));
        this.params = (String[])Utils.coalesce(params, EMPTY_PARAMS);
        if (lastModified instanceof Long) {
            this.setLastModified((Long)lastModified);
        } else if (lastModified instanceof Date) {
            this.setLastModified(((Date)lastModified).getTime());
        } else if (Utils.isNumber(String.valueOf(lastModified))) {
            this.setLastModified(Long.valueOf(lastModified.toString()));
        } else if (lastModified != null) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_LASTMODIFIED, lastModified));
        }
    }

    public static GraphicResource create(FacesContext context2, ValueExpression value, String type, Object lastModified) {
        MethodReference methodReference = ExpressionInspector.getMethodReference(context2.getELContext(), value);
        Method beanMethod = methodReference.getMethod();
        if (beanMethod == null) {
            throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_METHOD, value.getExpressionString()));
        }
        Class<?> beanClass = methodReference.getBase().getClass();
        String name = GraphicResource.getResourceBaseName(beanClass, beanMethod);
        if (!ALLOWED_METHODS.containsKey(name)) {
            if (!Utils.isOneAnnotationPresent(beanClass, REQUIRED_ANNOTATION_TYPES)) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_SCOPE, beanClass));
            }
            if (!Utils.isOneOf(beanMethod.getReturnType(), REQUIRED_RETURN_TYPES)) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_RETURNTYPE, beanMethod.getReturnType()));
            }
            ALLOWED_METHODS.put(name, new MethodReference(methodReference.getBase(), beanMethod));
        }
        Object[] params = methodReference.getActualParameters();
        String[] convertedParams = GraphicResource.convertToStrings(context2, params, beanMethod.getParameterTypes());
        return new GraphicResource(name + (Utils.isEmpty(type) ? "" : "." + type), convertedParams, lastModified);
    }

    @Override
    public String getRequestPath() {
        if (this.base64 != null) {
            return "data:" + this.getContentType() + ";base64," + this.base64;
        }
        String queryString = Utils.isEmpty(this.params) ? "" : "&" + Servlets.toQueryString(Collections.singletonMap("p", Arrays.asList(this.params)));
        return super.getRequestPath() + queryString;
    }

    public InputStream getInputStream() throws IOException {
        Object content;
        Object[] convertedParams;
        Method method;
        MethodReference methodReference = ALLOWED_METHODS.get(this.getResourceName().split("\\.", 2)[0]);
        try {
            method = methodReference.getMethod();
            convertedParams = GraphicResource.convertToObjects(Faces.getContext(), this.params, method.getParameterTypes());
        }
        catch (Exception ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; this can only be a hacker attempt.", ignore);
            return null;
        }
        try {
            content = method.invoke(methodReference.getBase(), convertedParams);
        }
        catch (Exception e2) {
            throw new FacesException((Throwable)e2);
        }
        if (content instanceof InputStream) {
            return (InputStream)content;
        }
        if (content instanceof byte[]) {
            return new ByteArrayInputStream((byte[])content);
        }
        return null;
    }

    private static Map<String, String> createContentTypesByBase64Header() {
        HashMap<String, String> contentTypesByBase64Header = new HashMap<String, String>();
        contentTypesByBase64Header.put("UklGR", "image/webp");
        contentTypesByBase64Header.put("/9j/", "image/jpeg");
        contentTypesByBase64Header.put("iVBORw", "image/png");
        contentTypesByBase64Header.put("R0lGOD", "image/gif");
        contentTypesByBase64Header.put("AAABAA", "image/x-icon");
        contentTypesByBase64Header.put("PD94bW", "image/svg+xml");
        contentTypesByBase64Header.put("Qk0", "image/bmp");
        contentTypesByBase64Header.put("SUkqAA", "image/tiff");
        contentTypesByBase64Header.put("TU0AKg", "image/tiff");
        return Collections.unmodifiableMap(contentTypesByBase64Header);
    }

    public static void registerGraphicImageBeans() {
        BeanManager beanManager = Beans.getManager();
        for (Bean bean : beanManager.getBeans(Object.class, new Annotation[]{ANY})) {
            Class beanClass = bean.getBeanClass();
            if (!Utils.isOneAnnotationPresent(beanClass, GraphicImageBean.class)) continue;
            Object instance = BeansLocal.getReference(beanManager, bean);
            boolean registered = false;
            for (Method method : beanClass.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !Utils.isOneInstanceOf(method.getReturnType(), REQUIRED_RETURN_TYPES)) continue;
                String resourceBaseName = GraphicResource.getResourceBaseName(beanClass, method);
                MethodReference methodReference = new MethodReference(instance, method);
                ALLOWED_METHODS.put(resourceBaseName, methodReference);
                registered = true;
            }
            if (registered) continue;
            throw new IllegalArgumentException(String.format(ERROR_MISSING_METHOD, beanClass.getName()));
        }
    }

    private static String getResourceBaseName(Class<?> beanClass, Method beanMethod) {
        return beanClass.getSimpleName().replaceAll("\\W", "") + "_" + beanMethod.getName();
    }

    private static String getContentType(String resourceName) {
        if (!resourceName.contains(".")) {
            return DEFAULT_CONTENT_TYPE;
        }
        String contentType = Faces.getExternalContext().getMimeType(resourceName);
        if (contentType == null) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_TYPE, resourceName.split("\\.", 2)[1]));
        }
        return contentType;
    }

    private static String guessContentType(String base64) {
        for (Map.Entry<String, String> contentTypeByBase64Header : CONTENT_TYPES_BY_BASE64_HEADER.entrySet()) {
            if (!base64.startsWith(contentTypeByBase64Header.getKey())) continue;
            return contentTypeByBase64Header.getValue();
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private static String convertToBase64(Object content) {
        byte[] bytes;
        if (content instanceof InputStream) {
            try {
                bytes = Utils.toByteArray((InputStream)content);
            }
            catch (IOException e2) {
                throw new FacesException((Throwable)e2);
            }
        } else if (content instanceof byte[]) {
            bytes = (byte[])content;
        } else {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_RETURNTYPE, content));
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static String[] convertToStrings(FacesContext context2, Object[] values, Class<?>[] types) {
        GraphicResource.validateParamLength(values, types);
        String[] strings = new String[values.length];
        UIOutput dummyComponent = new UIOutput();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            Converter converter = FacesLocal.createConverter(context2, types[i]);
            strings[i] = converter != null ? converter.getAsString(context2, (UIComponent)dummyComponent, value) : Utils.coalesce(value, "").toString();
        }
        return strings;
    }

    private static Object[] convertToObjects(FacesContext context2, String[] values, Class<?>[] types) {
        GraphicResource.validateParamLength(values, types);
        Object[] objects = new Object[values.length];
        UIOutput dummyComponent = new UIOutput();
        for (int i = 0; i < values.length; ++i) {
            String value = Utils.isEmpty(values[i]) ? null : values[i];
            Converter converter = FacesLocal.createConverter(context2, types[i]);
            objects[i] = converter != null ? converter.getAsObject(context2, (UIComponent)dummyComponent, value) : value;
        }
        return objects;
    }

    private static void validateParamLength(Object[] params, Class<?>[] types) {
        if (params.length != types.length) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_PARAMS, Arrays.toString(params)));
        }
    }
}

