/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.filter.HttpFilter;
import org.omnifaces.servlet.BufferedHttpServletResponse;

public class OnDemandResponseBufferFilter
extends HttpFilter {
    public static final String BUFFERED_RESPONSE = "org.omnifaces.servlet.BUFFERED_RESPONSE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        BufferedHttpServletResponse bufferedResponse = new BufferedHttpServletResponse(response);
        bufferedResponse.setPassThrough(true);
        request.setAttribute(BUFFERED_RESPONSE, (Object)bufferedResponse);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)bufferedResponse);
        }
        finally {
            if (!bufferedResponse.isPassThrough()) {
                response.getWriter().write(bufferedResponse.getBufferAsString());
            }
        }
    }
}

