/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.filter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.config.WebXml;
import org.omnifaces.exceptionhandler.FullAjaxExceptionHandler;
import org.omnifaces.filter.HttpFilter;
import org.omnifaces.util.Exceptions;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;

public class FacesExceptionFilter
extends HttpFilter {
    private static final Logger logger = Logger.getLogger(FacesExceptionFilter.class.getName());
    private static final String LOG_EXCEPTION_HANDLED = "FacesExceptionFilter: An exception occurred during processing servlet request. Error page '%s' will be shown.";
    private Class<? extends Throwable>[] exceptionTypesToUnwrap;
    private Class<? extends Throwable>[] exceptionTypesToIgnoreInLogging;

    @Override
    public void init() throws ServletException {
        this.exceptionTypesToUnwrap = FullAjaxExceptionHandler.getExceptionTypesToUnwrap(this.getServletContext());
        this.exceptionTypesToIgnoreInLogging = FullAjaxExceptionHandler.getExceptionTypesToIgnoreInLogging(this.getServletContext());
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (FileNotFoundException ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; this is a JSF quirk and it should be interpreted as 404.", ignore);
            response.sendError(404, request.getRequestURI());
        }
        catch (Throwable exception) {
            request.setAttribute("org.omnifaces.exception_uuid", (Object)UUID.randomUUID().toString());
            Throwable cause = Exceptions.unwrap(exception instanceof ServletException ? exception.getCause() : exception, this.exceptionTypesToUnwrap);
            String location = WebXml.instance().findErrorPageLocation(cause);
            this.logException(request, cause, location, LOG_EXCEPTION_HANDLED, location);
            if (Objects.equals(exception, cause)) {
                throw exception;
            }
            logger.log(Level.FINEST, "Ignoring thrown exception; this is a wrapper exception and only its root cause is of interest.", exception);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ServletException(cause);
        }
    }

    protected void logException(HttpServletRequest request, Throwable exception, String location, String message, Object ... parameters) {
        if (!Utils.isOneInstanceOf(exception.getClass(), this.exceptionTypesToIgnoreInLogging)) {
            logger.log(Level.SEVERE, String.format("[%s][%s] %s", request.getAttribute("org.omnifaces.exception_uuid"), Servlets.getRemoteAddr(request), String.format(message, parameters)), exception);
        }
    }
}

