/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.eventlistener;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.event.PostInvokeActionEvent;
import org.omnifaces.event.PreInvokeActionEvent;
import org.omnifaces.eventlistener.DefaultPhaseListener;
import org.omnifaces.util.Events;
import org.omnifaces.util.Utils;

public class InvokeActionEventListener
extends DefaultPhaseListener
implements SystemEventListener {
    private static final long serialVersionUID = 1L;

    public InvokeActionEventListener() {
        super(PhaseId.INVOKE_APPLICATION);
        Events.subscribeToApplicationEvent(PostValidateEvent.class, this);
    }

    public boolean isListenerForSource(Object source) {
        if (!(source instanceof UIComponent)) {
            return false;
        }
        UIComponent component = (UIComponent)source;
        return !Utils.isEmpty(component.getListenersForEventClass(PreInvokeActionEvent.class)) || !Utils.isEmpty(component.getListenersForEventClass(PostInvokeActionEvent.class));
    }

    public void processEvent(SystemEvent event) {
        FacesContext context2 = FacesContext.getCurrentInstance();
        if (!context2.isValidationFailed()) {
            UIComponent component = (UIComponent)event.getSource();
            InvokeActionEventListener.checkAndAddComponentWithListeners(context2, component, PreInvokeActionEvent.class);
            InvokeActionEventListener.checkAndAddComponentWithListeners(context2, component, PostInvokeActionEvent.class);
        }
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        InvokeActionEventListener.publishEvent(event.getFacesContext(), PreInvokeActionEvent.class);
    }

    @Override
    public void afterPhase(PhaseEvent event) {
        InvokeActionEventListener.publishEvent(event.getFacesContext(), PostInvokeActionEvent.class);
    }

    private static <T extends SystemEvent> void checkAndAddComponentWithListeners(FacesContext context2, UIComponent component, Class<T> type) {
        if (!Utils.isEmpty(component.getListenersForEventClass(type))) {
            LinkedHashSet<UIComponent> components = (LinkedHashSet<UIComponent>)context2.getAttributes().get(type);
            if (components == null) {
                components = new LinkedHashSet<UIComponent>();
                context2.getAttributes().put(type, components);
            }
            components.add(component);
        }
    }

    private static <T extends SystemEvent> void publishEvent(FacesContext context2, Class<T> type) {
        Set components = (Set)context2.getAttributes().get(type);
        if (components != null) {
            for (UIComponent component : components) {
                context2.getApplication().publishEvent(context2, type, (Object)component);
            }
        }
    }
}

