/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.eventlistener;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;

public class CallbackPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        for (PhaseListener phaseListener : CallbackPhaseListener.getCallbackPhaseListenersForEvent(event)) {
            phaseListener.beforePhase(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        for (PhaseListener phaseListener : CallbackPhaseListener.getCallbackPhaseListenersForEvent(event)) {
            phaseListener.afterPhase(event);
        }
    }

    public static void add(PhaseListener phaseListener) {
        CallbackPhaseListener.getCallbackPhaseListeners(Faces.getContext(), true).add(phaseListener);
    }

    public static boolean remove(PhaseListener phaseListener) {
        Set<PhaseListener> phaseListeners = CallbackPhaseListener.getCallbackPhaseListeners(Faces.getContext(), false);
        return phaseListeners != null && phaseListeners.remove(phaseListener);
    }

    private static Set<PhaseListener> getCallbackPhaseListeners(FacesContext context2, boolean create) {
        return FacesLocal.getRequestAttribute(context2, CallbackPhaseListener.class.getName(), () -> create ? new HashSet(1) : null);
    }

    private static Set<PhaseListener> getCallbackPhaseListenersForEvent(PhaseEvent event) {
        Set<PhaseListener> phaseListeners = CallbackPhaseListener.getCallbackPhaseListeners(event.getFacesContext(), false);
        if (phaseListeners == null) {
            return Collections.emptySet();
        }
        HashSet<PhaseListener> phaseListenersForEvent = new HashSet<PhaseListener>();
        for (PhaseListener phaseListener : phaseListeners) {
            if (!CallbackPhaseListener.isPhaseMatch(event, phaseListener.getPhaseId())) continue;
            phaseListenersForEvent.add(phaseListener);
        }
        return Collections.unmodifiableSet(phaseListenersForEvent);
    }

    private static boolean isPhaseMatch(PhaseEvent event, PhaseId phaseId) {
        return PhaseId.ANY_PHASE.equals(phaseId) || event.getPhaseId().equals(phaseId);
    }
}

