/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.nio.charset.StandardCharsets;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.Base64;
import java.util.regex.Pattern;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class Strings {
    private static final Pattern PATTERN_DIACRITICAL_MARKS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Pattern PATTERN_NON_ALPHANUMERIC_CHARS = Pattern.compile("[^\\p{Alnum}]+");
    private static final Pattern PATTERN_XML_TAGS = Pattern.compile("\\<[^\\>]*+\\>");
    private static final Pattern PATTERN_MULTIPLE_SPACES = Pattern.compile("\\s\\s+");

    private Strings() {
    }

    public static String abbreviate(String text, int size) {
        if (text == null) {
            return null;
        }
        if (text.length() > size) {
            return text.substring(0, size).trim() + "...";
        }
        return text;
    }

    public static String concat(Object left, Object right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right.toString();
        }
        if (right == null) {
            return left.toString();
        }
        return left.toString() + right.toString();
    }

    public static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Character.toTitleCase(string.charAt(0)) + string.substring(1);
    }

    public static String parenthesize(Object object) {
        if (Utils.isEmpty(object) || "0".equals(object.toString())) {
            return null;
        }
        return Strings.format("({0})", object);
    }

    public static String replaceAll(String value, String pattern, String replacement) {
        if (value == null) {
            return null;
        }
        return value.replaceAll(pattern, replacement);
    }

    public static boolean matches(String value, String pattern) {
        return value != null && value.matches(pattern);
    }

    public static String prettyURL(String string) {
        if (string == null) {
            return null;
        }
        String normalized = Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
        String withoutDiacriticalMarks = PATTERN_DIACRITICAL_MARKS.matcher(normalized).replaceAll("");
        return PATTERN_NON_ALPHANUMERIC_CHARS.matcher(withoutDiacriticalMarks).replaceAll("-");
    }

    public static String encodeURL(String string) {
        return Utils.encodeURL(string);
    }

    public static String encodeURI(String string) {
        return Utils.encodeURI(string);
    }

    public static String encodeBase64(String string) {
        if (string == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String escapeJS(String string) {
        return Utils.escapeJS(string, true);
    }

    public static String stripTags(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String withoutTags = PATTERN_XML_TAGS.matcher(string).replaceAll("");
        return PATTERN_MULTIPLE_SPACES.matcher(withoutTags).replaceAll(" ").trim();
    }

    public static String format1(String pattern, Object param1) {
        return Strings.format(pattern, param1);
    }

    public static String format2(String pattern, Object param1, Object param2) {
        return Strings.format(pattern, param1, param2);
    }

    public static String format3(String pattern, Object param1, Object param2, Object param3) {
        return Strings.format(pattern, param1, param2, param3);
    }

    public static String format4(String pattern, Object param1, Object param2, Object param3, Object param4) {
        return Strings.format(pattern, param1, param2, param3, param4);
    }

    public static String format5(String pattern, Object param1, Object param2, Object param3, Object param4, Object param5) {
        return Strings.format(pattern, param1, param2, param3, param4, param5);
    }

    private static String format(String pattern, Object ... params) {
        StringBuffer result = new StringBuffer();
        new MessageFormat(pattern, Faces.getLocale()).format(params, result, (FieldPosition)null);
        return result.toString();
    }
}

