/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.util.stream.IntStream;

public final class Arrays {
    private static final String ERROR_INVALID_ARRAY_SIZE = "The array size must be at least 0.";

    private Arrays() {
    }

    public static Object[] createArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(ERROR_INVALID_ARRAY_SIZE);
        }
        return new Object[size];
    }

    public static Integer[] createIntegerArray(int begin, int end) {
        IntStream range = IntStream.rangeClosed(Math.min(begin, end), Math.max(begin, end));
        if (begin > end) {
            range = range.map(i -> begin + end - i);
        }
        return (Integer[])range.boxed().toArray(Integer[]::new);
    }

    public static boolean contains(Object[] array, Object item) {
        if (array == null || item == null) {
            return false;
        }
        for (Object object : array) {
            if (object == null || !object.toString().equals(item.toString())) continue;
            return true;
        }
        return false;
    }

    public static Object[] reverseArray(Object[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        Object[] reversed = new Object[length];
        for (int i = 0; i < length; ++i) {
            reversed[i] = array[length - 1 - i];
        }
        return reversed;
    }
}

