/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.converter;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Utils;

@FacesConverter(value="omnifaces.ToCollectionConverter")
public class ToCollectionConverter
implements Converter<Collection> {
    private static final String DEFAULT_DELIMITER = ",";
    private static final String DEFAULT_SET_TYPE = "java.util.LinkedHashSet";
    private static final String DEFAULT_COLLECTION_TYPE = "java.util.ArrayList";
    private String delimiter;
    private String collectionType;
    private Object itemConverter;

    public Collection getAsObject(FacesContext context2, UIComponent component, String submittedValue) {
        if (Utils.isEmpty(submittedValue)) {
            return null;
        }
        String type = this.collectionType;
        Converter converter = Faces.createConverter(this.itemConverter);
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression != null) {
            Type[] actualTypeArguments;
            Method getter = ExpressionInspector.getMethodReference(context2.getELContext(), valueExpression).getMethod();
            Class<?> returnType = getter.getReturnType();
            if (!Collection.class.isAssignableFrom(returnType)) {
                throw new IllegalArgumentException(valueExpression.getExpressionString() + " does not resolve to Collection.");
            }
            if (this.collectionType == null && Set.class.isAssignableFrom(returnType)) {
                type = DEFAULT_SET_TYPE;
            }
            if (converter == null && (actualTypeArguments = ((ParameterizedType)getter.getGenericReturnType()).getActualTypeArguments()).length > 0) {
                Class forClass = (Class)actualTypeArguments[0];
                converter = context2.getApplication().createConverter(forClass);
            }
        }
        Collection collection = (Collection)Reflection.instance(Utils.coalesce(type, DEFAULT_COLLECTION_TYPE));
        for (String item : submittedValue.split(Pattern.quote(Utils.coalesce(this.delimiter, DEFAULT_DELIMITER)))) {
            String trimmed = item.trim();
            collection.add(converter == null ? trimmed : converter.getAsObject(context2, component, trimmed));
        }
        return collection;
    }

    public String getAsString(FacesContext context2, UIComponent component, Collection modelValue) {
        if (Utils.isEmpty(modelValue)) {
            return "";
        }
        Application application = context2.getApplication();
        StringBuilder builder = new StringBuilder();
        String specifiedDelimiter = Utils.coalesce(this.delimiter, DEFAULT_DELIMITER);
        Converter specifiedConverter = Faces.createConverter(this.itemConverter);
        Class<?> forClass = null;
        Converter converter = specifiedConverter;
        int i = 0;
        for (Object item : modelValue) {
            if (i++ > 0) {
                builder.append(specifiedDelimiter);
            }
            if (specifiedConverter == null && item != null && forClass != item.getClass()) {
                forClass = item.getClass();
                converter = application.createConverter(forClass);
            }
            builder.append(converter == null ? Utils.coalesce(item, "") : converter.getAsString(context2, component, item));
        }
        return builder.toString();
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public void setItemConverter(Object itemConverter) {
        this.itemConverter = itemConverter;
    }
}

