/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.converter;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.omnifaces.util.Messages;

@FacesConverter(value="omnifaces.ListIndexConverter")
public class ListIndexConverter
implements Converter<Object> {
    private static final String ERROR_LIST_INDEX = "Could not determine index for value ''{0}'' in component {1}.";
    private static final String ERROR_LIST_INDEX_BOUNDS = "Index {0} for value {1} in component {2} is out of bounds.";
    private static final String ERROR_VALUE_NOT_IN_LIST = "Object {0} in component {1} does not appear to be present in the given list.";
    private List<?> list;

    public Object getAsObject(FacesContext context2, UIComponent component, String value) {
        int index;
        try {
            index = Integer.valueOf(value);
        }
        catch (NumberFormatException e2) {
            throw new ConverterException(Messages.createError(ERROR_LIST_INDEX, value, component.getClientId(context2)), (Throwable)e2);
        }
        if (index < 0 || index >= this.list.size()) {
            throw new ConverterException(Messages.createError(ERROR_LIST_INDEX_BOUNDS, index, value, component.getClientId(context2)));
        }
        return this.list.get(index);
    }

    public String getAsString(FacesContext context2, UIComponent component, Object value) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).equals(value)) continue;
            return Integer.toString(i);
        }
        throw new ConverterException(Messages.createError(ERROR_VALUE_NOT_IN_LIST, value == null ? "null" : value.toString(), component.getClientId(context2)));
    }

    public void setList(List<?> list) {
        this.list = list;
    }
}

