/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.context;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.FlashWrapper;
import org.omnifaces.cdi.viewscope.ViewScopeManager;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Hacks;

public class OmniExternalContext
extends ExternalContextWrapper {
    private static final Flash DUMMY_FLASH = new DummyFlash();

    public OmniExternalContext(ExternalContext wrapped) {
        super(wrapped);
    }

    public Flash getFlash() {
        if (ViewScopeManager.isUnloadRequest(Faces.getContext())) {
            return DUMMY_FLASH;
        }
        Flash flash = super.getFlash();
        if (Faces.isSessionNew() && Hacks.isMojarraUsed()) {
            return new PatchedFlash(flash);
        }
        return flash;
    }

    private static class DummyFlash
    extends Flash {
        private DummyFlash() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Object get(Object key) {
            return null;
        }

        public Object put(String key, Object value) {
            return null;
        }

        public Object remove(Object key) {
            return null;
        }

        public void putAll(Map<? extends String, ? extends Object> m) {
        }

        public void clear() {
        }

        public Set<String> keySet() {
            return Collections.emptySet();
        }

        public Collection<Object> values() {
            return Collections.emptySet();
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }

        public boolean isKeepMessages() {
            return false;
        }

        public void setKeepMessages(boolean newValue) {
        }

        public boolean isRedirect() {
            return false;
        }

        public void setRedirect(boolean newValue) {
        }

        public void putNow(String key, Object value) {
        }

        public void keep(String key) {
        }

        public void doPrePhaseActions(FacesContext ctx) {
        }

        public void doPostPhaseActions(FacesContext ctx) {
        }
    }

    private static class PatchedFlash
    extends FlashWrapper {
        public PatchedFlash(Flash wrapped) {
            super(wrapped);
        }

        public Object get(Object key) {
            try {
                return super.get(key);
            }
            catch (NullPointerException e2) {
                return null;
            }
        }
    }
}

