/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.tree;

import java.io.IOException;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.omnifaces.component.tree.Tree;
import org.omnifaces.component.tree.TreeFamily;
import org.omnifaces.component.tree.TreeNode;
import org.omnifaces.model.tree.TreeModel;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;

@FacesComponent(value="org.omnifaces.component.tree.TreeNodeItem")
public class TreeNodeItem
extends TreeFamily {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.tree.TreeNodeItem";

    @Override
    protected void validateHierarchy() {
        Components.validateHasParent((UIComponent)this, TreeNode.class);
        Components.validateHasNoParent((UIComponent)this, TreeNodeItem.class);
    }

    public void encodeAll(FacesContext context2) throws IOException {
        this.encodeChildren(context2);
    }

    @Override
    protected void process(FacesContext context2, PhaseId phaseId) {
        if (this.getChildCount() == 0) {
            return;
        }
        this.process(context2, (Tree tree) -> {
            if (tree.getCurrentModelNode() != null) {
                for (TreeModel childModelNode : tree.getCurrentModelNode()) {
                    tree.setCurrentModelNode(context2, childModelNode);
                    if (!this.isRendered()) continue;
                    this.processSuper(context2, phaseId);
                }
            }
            return null;
        });
    }

    public boolean visitTree(VisitContext context2, VisitCallback callback) {
        if (context2.getHints().contains(VisitHint.SKIP_ITERATION)) {
            return super.visitTree(context2, callback);
        }
        if (!this.isVisitable(context2) || this.getChildCount() == 0) {
            return false;
        }
        return this.process(context2.getFacesContext(), (Tree tree) -> {
            if (tree.getCurrentModelNode() != null) {
                for (TreeModel childModelNode : tree.getCurrentModelNode()) {
                    tree.setCurrentModelNode(context2.getFacesContext(), childModelNode);
                    if (!TreeNodeItem.super.visitTree(context2, callback)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R process(FacesContext context2, Callback.ReturningWithArgument<R, Tree> callback) {
        Tree tree = Components.getClosestParent((UIComponent)this, Tree.class);
        TreeModel originalModelNode = tree.getCurrentModelNode();
        try {
            R r = callback.invoke(tree);
            return r;
        }
        finally {
            tree.setCurrentModelNode(context2, originalModelNode);
        }
    }
}

