/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output.cache.el;

import java.io.Serializable;
import java.util.Objects;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.omnifaces.component.output.Cache;
import org.omnifaces.el.ValueExpressionWrapper;
import org.omnifaces.util.Faces;

public class CachingValueExpression
extends ValueExpressionWrapper {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final transient Cache cache;

    public CachingValueExpression(String name, ValueExpression valueExpression, Cache cache) {
        super(valueExpression);
        this.name = name;
        this.cache = cache;
    }

    @Override
    public Object getValue(ELContext elContext) {
        FacesContext facesContext = Faces.getContext(elContext);
        Serializable value = this.cache.getCacheAttribute(facesContext, this.name);
        if (value == null) {
            value = (Serializable)super.getValue(elContext);
            this.cache.setCacheAttribute(facesContext, this.name, value);
        }
        return value;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals(this.name, ((CachingValueExpression)((Object)object)).name);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.name);
    }
}

