/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.omnifaces.resourcehandler.GraphicResource;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Renderers;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.output.GraphicImage")
@ResourceDependency(library="omnifaces", name="omnifaces.js", target="head")
public class GraphicImage
extends HtmlGraphicImage {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.output.GraphicImage";
    protected static final Map<String, String> ATTRIBUTE_NAMES = GraphicImage.collectAttributeNames();
    private static final String ERROR_MISSING_VALUE = "o:graphicImage 'value' attribute is required.";
    private final State state = new State(this.getStateHelper());

    public GraphicImage() {
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context2) throws IOException {
        ResponseWriter writer = context2.getResponseWriter();
        writer.startElement("img", (UIComponent)this);
        Renderers.writeIdAttributeIfNecessary(writer, (UIComponent)this);
        String src = this.getSrc(context2);
        if (this.isLazy() && !this.isDataURI()) {
            writer.writeAttribute("src", (Object)"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg'/%3E", null);
            writer.writeAttribute("data-src", (Object)src, "value");
            writer.writeAttribute("data-lazy", (Object)"true", "lazy");
        } else {
            writer.writeAttribute("src", (Object)src, "value");
        }
        Renderers.writeAttributes(writer, (UIComponent)this, ATTRIBUTE_NAMES);
    }

    public void encodeEnd(FacesContext context2) throws IOException {
        ResponseWriter writer = context2.getResponseWriter();
        writer.endElement("img");
    }

    protected String getSrc(FacesContext context2) throws IOException {
        Resource resource;
        String name = (String)this.getAttributes().get("name");
        boolean dataURI = this.isDataURI();
        if (name != null) {
            resource = this.createGraphicResourceByName(context2, name, dataURI);
            if (resource == null) {
                return "RES_NOT_FOUND";
            }
        } else {
            ValueExpression value = this.getValueExpression("value");
            if (value != null) {
                resource = this.createGraphicResourceByValue(context2, value, dataURI);
            } else {
                throw new IllegalArgumentException(ERROR_MISSING_VALUE);
            }
        }
        String url = context2.getExternalContext().encodeResourceURL(resource.getRequestPath());
        String fragment = (String)this.getAttributes().get("fragment");
        if (dataURI || Utils.isEmpty(fragment)) {
            return url;
        }
        return url + (fragment.charAt(0) == '#' ? "" : "#") + fragment;
    }

    private Resource createGraphicResourceByName(FacesContext context2, String name, boolean dataURI) throws IOException {
        String library = (String)this.getAttributes().get("library");
        Resource resource = FacesLocal.createResource(context2, library, name);
        if (resource != null && dataURI && resource.getContentType().startsWith("image")) {
            resource = new GraphicResource(resource.getInputStream(), resource.getContentType());
        }
        return resource;
    }

    private Resource createGraphicResourceByValue(FacesContext context2, ValueExpression value, boolean dataURI) {
        String type = (String)this.getAttributes().get("type");
        if (dataURI) {
            return new GraphicResource(value.getValue(context2.getELContext()), type);
        }
        return GraphicResource.create(context2, value, type, this.getAttributes().get("lastModified"));
    }

    public String getAlt() {
        return Utils.coalesce(super.getAlt(), "");
    }

    public boolean isDataURI() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.dataURI), false);
    }

    public void setDataURI(boolean dataURI) {
        this.state.put((Serializable)((Object)PropertyKeys.dataURI), dataURI);
    }

    public boolean isLazy() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.lazy), false);
    }

    public void setLazy(boolean lazy) {
        this.state.put((Serializable)((Object)PropertyKeys.lazy), lazy);
    }

    private static Map<String, String> collectAttributeNames() {
        HashMap<String, String> attributeNames = new HashMap<String, String>();
        for (HtmlGraphicImage.PropertyKeys propertyKey : HtmlGraphicImage.PropertyKeys.values()) {
            String name;
            attributeNames.put(name, "styleClass".equals(name = propertyKey.name()) ? "class" : propertyKey.toString());
        }
        return Collections.unmodifiableMap(attributeNames);
    }

    private static enum PropertyKeys {
        dataURI,
        lazy;

    }
}

