/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.FacesComponent;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import org.omnifaces.component.output.OutputFamily;
import org.omnifaces.filter.OnDemandResponseBufferFilter;
import org.omnifaces.servlet.BufferedHttpServletResponse;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.State;
import org.omnifaces.util.cache.CacheFactory;

@FacesComponent(value="org.omnifaces.component.output.Cache")
public class Cache
extends OutputFamily {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.output.Cache";
    public static final String VALUE_SET = "org.omnifaces.cache.VALUE_SET";
    public static final String DEFAULT_SCOPE = "session";
    public static final String START_CONTENT_MARKER = "<!-- START CACHE FOR %s -->";
    public static final String END_CONTENT_MARKER = "<!-- END CACHE FOR %s -->";
    private static final String ERROR_NO_BUFFERED_RESPONSE = String.format("No buffered response found in request, but 'useBuffer' set to true. Check setting the '%s' context parameter or installing the '%s' filter manually.", "org.omnifaces.CACHE_INSTALL_BUFFER_FILTER", OnDemandResponseBufferFilter.class);
    private static final Class<? extends SystemEvent> PRE_RENDER = PreRenderViewEvent.class;
    private final State state = new State(this.getStateHelper());

    public Cache() {
        FacesContext context2 = FacesContext.getCurrentInstance();
        Events.subscribeToViewEvent(PRE_RENDER, () -> this.processPreRenderViewEvent(context2));
    }

    private void processPreRenderViewEvent(FacesContext context2) {
        if (!this.isDisabled() && this.isUseBuffer() && !this.hasCachedValue(context2)) {
            BufferedHttpServletResponse bufferedResponse = (BufferedHttpServletResponse)((Object)Faces.getRequestAttribute("org.omnifaces.servlet.BUFFERED_RESPONSE"));
            if (bufferedResponse == null) {
                throw new IllegalStateException(ERROR_NO_BUFFERED_RESPONSE);
            }
            bufferedResponse.setPassThrough(false);
            Events.subscribeToRequestAfterPhase(PhaseId.RENDER_RESPONSE, () -> this.processPostRenderResponsePhase(context2, bufferedResponse));
        }
    }

    private void processPostRenderResponsePhase(FacesContext context2, BufferedHttpServletResponse bufferedResponse) {
        String content = null;
        try {
            content = this.getContentFromBuffer(bufferedResponse.getBufferAsString());
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        if (content != null) {
            this.cacheContent(context2, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeChildren(FacesContext context2) throws IOException {
        String childRendering;
        if (this.isDisabled()) {
            super.encodeChildren(context2);
            return;
        }
        String key = this.getKeyWithDefault(context2);
        ResponseWriter responseWriter = context2.getResponseWriter();
        org.omnifaces.util.cache.Cache scopedCache = this.getCacheImpl(context2);
        if (this.isReset()) {
            scopedCache.remove(key);
        }
        if ((childRendering = scopedCache.get(key)) == null) {
            StringWriter bufferWriter = new StringWriter();
            ResponseWriter bufferedResponseWriter = responseWriter.cloneWithWriter((Writer)bufferWriter);
            context2.setResponseWriter(bufferedResponseWriter);
            try {
                if (this.isUseBuffer()) {
                    bufferedResponseWriter.write(this.getStartContentMarker());
                }
                super.encodeChildren(context2);
                if (this.isUseBuffer()) {
                    bufferedResponseWriter.write(this.getEndContentMarker());
                }
            }
            finally {
                context2.setResponseWriter(responseWriter);
            }
            childRendering = ((Object)bufferWriter).toString();
            this.cacheContent(context2, scopedCache, key, childRendering);
        }
        responseWriter.write(childRendering);
    }

    public Serializable getCacheAttribute(FacesContext context2, String name) {
        return this.getCacheImpl(context2).getAttribute(this.getKeyWithDefault(context2), name);
    }

    public void setCacheAttribute(FacesContext context2, String name, Serializable value) {
        this.getCacheImpl(context2).putAttribute(this.getKeyWithDefault(context2), name, value, this.getTime());
    }

    protected boolean isVisitable(VisitContext visitContext) {
        FacesContext context2 = visitContext.getFacesContext();
        return this.isDisabled() || this.isCachedValueJustSet(context2) || !this.hasCachedValue(context2);
    }

    private void cacheContent(FacesContext context2, String content) {
        this.cacheContent(context2, CacheFactory.getCache(context2, this.getScope()), this.getKeyWithDefault(context2), content);
    }

    private void cacheContent(FacesContext context2, org.omnifaces.util.cache.Cache scopedCache, String key, String content) {
        int time = this.getTime();
        if (time > 0) {
            scopedCache.put(key, content, time);
        } else {
            scopedCache.put(key, content);
        }
        context2.getExternalContext().getRequestMap().put(VALUE_SET, Boolean.TRUE);
    }

    private String getKeyWithDefault(FacesContext context2) {
        String key = this.getKey();
        if (key == null) {
            key = context2.getViewRoot().getViewId() + "_" + this.getClientId(context2);
        }
        return key;
    }

    private org.omnifaces.util.cache.Cache getCacheImpl(FacesContext context2) {
        return CacheFactory.getCache(context2, this.getScope());
    }

    private boolean isCachedValueJustSet(FacesContext context2) {
        return Boolean.TRUE.equals(context2.getExternalContext().getRequestMap().get(VALUE_SET));
    }

    private boolean hasCachedValue(FacesContext context2) {
        return CacheFactory.getCache(context2, this.getScope()).get(this.getKeyWithDefault(context2)) != null;
    }

    private String getStartContentMarker() {
        return String.format(START_CONTENT_MARKER, this.getClientId());
    }

    private String getEndContentMarker() {
        return String.format(END_CONTENT_MARKER, this.getClientId());
    }

    private String getContentFromBuffer(String buffer) {
        String endMarker;
        int endIndex;
        String startMarker = this.getStartContentMarker();
        int startIndex = buffer.indexOf(startMarker);
        if (startIndex != -1 && (endIndex = buffer.indexOf(endMarker = this.getEndContentMarker())) != -1) {
            return buffer.substring(startIndex + startMarker.length(), endIndex);
        }
        return null;
    }

    public String getKey() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.key));
    }

    public void setKey(String keyValue) {
        this.state.put((Serializable)((Object)PropertyKeys.key), keyValue);
    }

    public String getScope() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.scope), DEFAULT_SCOPE);
    }

    public void setScope(String scopeValue) {
        this.state.put((Serializable)((Object)PropertyKeys.scope), scopeValue);
    }

    public Integer getTime() {
        return (Integer)this.state.get((Serializable)((Object)PropertyKeys.time), -1);
    }

    public void setTime(Integer timeValue) {
        this.state.put((Serializable)((Object)PropertyKeys.time), timeValue);
    }

    public boolean isUseBuffer() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.useBuffer), Boolean.FALSE);
    }

    public void setUseBuffer(boolean useBufferValue) {
        this.state.put((Serializable)((Object)PropertyKeys.useBuffer), useBufferValue);
    }

    public boolean isReset() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.reset), Boolean.FALSE);
    }

    public void setReset(boolean resetValue) {
        this.state.put((Serializable)((Object)PropertyKeys.reset), resetValue);
    }

    public boolean isDisabled() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.disabled), Boolean.FALSE);
    }

    public void setDisabled(boolean disabledValue) {
        this.state.put((Serializable)((Object)PropertyKeys.disabled), disabledValue);
    }

    static enum PropertyKeys {
        key,
        scope,
        time,
        useBuffer,
        reset,
        disabled;

    }
}

