/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.io.Serializable;
import javax.faces.component.UIViewParameter;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.omnifaces.util.Ajax;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.State;

public abstract class OnloadParam
extends UIViewParameter {
    protected final State state = new State(this.getStateHelper());

    protected OnloadParam() {
        Events.subscribeToRequestBeforePhase(PhaseId.RENDER_RESPONSE, this::registerScriptsIfNecessary);
    }

    private void registerScriptsIfNecessary() {
        FacesContext context2 = this.getFacesContext();
        if (!this.isOnloadParamRequest(context2)) {
            Components.addFormIfNecessary();
            Components.addScriptResource("javax.faces", "jsf.js");
            Components.addScriptResource("omnifaces", "omnifaces.js");
            if (!FacesLocal.isAjaxRequestWithPartialRendering(context2)) {
                String initScript;
                if (FacesLocal.getRequestMap(context2).put(((Object)((Object)this)).getClass().getName(), Boolean.TRUE) == null && (initScript = this.getInitScript(context2)) != null) {
                    Components.addScript(initScript);
                }
            } else {
                String updateScript = this.getUpdateScript(context2);
                if (updateScript != null) {
                    Components.addScript(updateScript);
                }
            }
        }
    }

    protected String getInitScript(FacesContext context2) {
        return null;
    }

    protected String getUpdateScript(FacesContext context2) {
        return null;
    }

    protected abstract String getEventValue(FacesContext var1);

    protected boolean isOnloadParamRequest(FacesContext context2) {
        return OnloadParam.isOnloadParamRequest(context2, this.getEventValue(context2));
    }

    public void processDecodes(FacesContext context2) {
        if (this.isOnloadParamRequest(context2) && Ajax.isExecuted(this.getClientId(context2))) {
            this.decodeAll(context2);
            context2.renderResponse();
        }
    }

    protected abstract void decodeAll(FacesContext var1);

    protected void decodeImmediately(FacesContext context2, String submittedValue) {
        this.setSubmittedValue(submittedValue);
        this.validate(context2);
        if (this.isValid()) {
            this.updateModel(context2);
        } else {
            this.setValid(true);
        }
        String render = this.getRender();
        if (render != null) {
            Ajax.update(render.split("\\s+"));
        }
    }

    public void processValidators(FacesContext context2) {
    }

    public void processUpdates(FacesContext context2) {
    }

    public String getRender() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.RENDER), "@none");
    }

    public void setRender(String render) {
        this.state.put((Serializable)((Object)PropertyKeys.RENDER), render);
    }

    protected static boolean isOnloadParamRequest(FacesContext context2, String onloadEvent) {
        return context2.isPostback() && onloadEvent.equals(FacesLocal.getRequestParameter(context2, "omnifaces.event"));
    }

    private static enum PropertyKeys {
        RENDER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

