/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.validator;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.inject.Inject;
import org.omnifaces.util.BeansLocal;

@ApplicationScoped
public class ValidatorManager {
    @Inject
    private BeanManager manager;
    private Map<String, Bean<Validator>> validatorsById = new HashMap<String, Bean<Validator>>();

    public Validator createValidator(Application application, String validatorId) {
        Validator validator = application.createValidator(validatorId);
        Bean<Validator> bean = this.validatorsById.get(validatorId);
        if (bean == null && !this.validatorsById.containsKey(validatorId)) {
            if (this.isUnmanaged(validator)) {
                bean = this.resolve(validator.getClass(), validatorId);
            }
            this.validatorsById.put(validatorId, bean);
        }
        return bean != null ? BeansLocal.getReference(this.manager, bean) : validator;
    }

    private boolean isUnmanaged(Validator validator) {
        if (validator == null) {
            return false;
        }
        FacesValidator annotation = validator.getClass().getAnnotation(FacesValidator.class);
        if (annotation == null) {
            return false;
        }
        return !annotation.managed();
    }

    private Bean<Validator> resolve(Class<? extends Validator> validatorClass, final String validatorId) {
        Bean<? extends Validator> bean = BeansLocal.resolveExact(this.manager, validatorClass, new Annotation[0]);
        if (bean == null) {
            FacesValidator annotation = validatorClass.getAnnotation(FacesValidator.class);
            if (annotation != null) {
                bean = BeansLocal.resolveExact(this.manager, validatorClass, new Annotation[]{annotation});
            }
            if (bean == null) {
                bean = BeansLocal.resolveExact(this.manager, validatorClass, new Annotation[]{new FacesValidator(){

                    public Class<? extends Annotation> annotationType() {
                        return FacesValidator.class;
                    }

                    public String value() {
                        return validatorId;
                    }

                    public boolean managed() {
                        return false;
                    }

                    public boolean isDefault() {
                        return false;
                    }
                }});
            }
        }
        return bean;
    }
}

