/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import org.omnifaces.cdi.push.SocketEvent;
import org.omnifaces.cdi.push.SocketSessionManager;
import org.omnifaces.cdi.push.SocketUserManager;
import org.omnifaces.util.Beans;

@SessionScoped
public class SocketChannelManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_INVALID_SCOPE = "o:socket 'scope' attribute '%s' does not represent a valid scope. It may not be an EL expression and allowed values are 'application', 'session' and 'view', case insensitive. The default is 'application'. When 'user' attribute is specified, then scope defaults to 'session' and may not be 'application'.";
    private static final String ERROR_DUPLICATE_CHANNEL = "o:socket channel '%s' is already registered on a different scope. Choose an unique channel name for a different channel (or shutdown all browsers and restart the server if you were just testing).";
    private static final int ESTIMATED_CHANNELS_PER_APPLICATION = 1;
    private static final int ESTIMATED_CHANNELS_PER_SESSION = 1;
    private static final int ESTIMATED_CHANNELS_PER_VIEW = 1;
    private static final int ESTIMATED_USERS_PER_SESSION = 1;
    static final int ESTIMATED_TOTAL_CHANNELS = 3;
    static final Map<String, String> EMPTY_SCOPE = Collections.emptyMap();
    private static final ConcurrentHashMap<String, String> APPLICATION_SCOPE = new ConcurrentHashMap(1);
    private final ConcurrentHashMap<String, String> sessionScopedChannels = new ConcurrentHashMap(1);
    private final ConcurrentHashMap<Serializable, String> sessionUsers = new ConcurrentHashMap(1);
    @Inject
    private SocketSessionManager socketSessions;
    @Inject
    private SocketUserManager socketUsers;

    protected String register(String channel, String scope, Serializable user) {
        switch (Scope.of(scope, user)) {
            case APPLICATION: {
                return this.register(null, channel, APPLICATION_SCOPE, this.sessionScopedChannels, this.getViewScopedChannels(false));
            }
            case SESSION: {
                return this.register(user, channel, this.sessionScopedChannels, APPLICATION_SCOPE, this.getViewScopedChannels(false));
            }
            case VIEW: {
                return this.register(user, channel, this.getViewScopedChannels(true), APPLICATION_SCOPE, this.sessionScopedChannels);
            }
        }
        throw new UnsupportedOperationException();
    }

    private String register(Serializable user, String channel, Map<String, String> targetScope, Map<String, String> ... otherScopes) {
        if (!targetScope.containsKey(channel)) {
            for (Map<String, String> otherScope : otherScopes) {
                if (!otherScope.containsKey(channel)) continue;
                throw new IllegalArgumentException(String.format(ERROR_DUPLICATE_CHANNEL, channel));
            }
            ((ConcurrentHashMap)targetScope).putIfAbsent(channel, channel + "?" + UUID.randomUUID().toString());
        }
        String channelId = targetScope.get(channel);
        if (user != null) {
            if (!this.sessionUsers.containsKey(user) && this.sessionUsers.putIfAbsent(user, UUID.randomUUID().toString()) == null) {
                this.socketUsers.register(user, this.sessionUsers.get(user));
            }
            this.socketUsers.addChannelId(this.sessionUsers.get(user), channel, channelId);
        }
        this.socketSessions.register(channelId);
        return channelId;
    }

    protected void switchUser(String channel, String scope, Serializable oldUser, Serializable newUser) {
        String userId;
        if (oldUser != null && (userId = this.sessionUsers.remove(oldUser)) != null) {
            this.socketUsers.deregister(oldUser, userId);
        }
        this.register(channel, scope, newUser);
        Beans.fireEvent(new SocketEvent(channel, newUser, oldUser, null), new Annotation[]{SocketEvent.Switched.LITERAL});
    }

    @PreDestroy
    protected void deregisterSessionScope() {
        for (Map.Entry<Serializable, String> sessionUser : this.sessionUsers.entrySet()) {
            this.socketUsers.deregister(sessionUser.getKey(), sessionUser.getValue());
        }
        this.socketSessions.deregister(this.sessionScopedChannels.values());
    }

    protected Map<String, String> getSessionScopedChannels() {
        return this.sessionScopedChannels;
    }

    protected Map<String, String> getViewScopedChannels(boolean create) {
        ViewScope bean = Beans.getInstance(ViewScope.class, create, new Annotation[0]);
        return bean == null ? EMPTY_SCOPE : bean.getChannels();
    }

    static SocketChannelManager getInstance() {
        return Beans.getReference(SocketChannelManager.class, new Annotation[0]);
    }

    static String getChannelId(String channel, Map<String, String> sessionScope, Map<String, String> viewScope) {
        String channelId = viewScope.get(channel);
        if (channelId == null && (channelId = sessionScope.get(channel)) == null) {
            channelId = APPLICATION_SCOPE.get(channel);
        }
        return channelId;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(APPLICATION_SCOPE);
        HashMap<String, ConcurrentHashMap<String, Set<String>>> sessionUserChannels = new HashMap<String, ConcurrentHashMap<String, Set<String>>>(this.sessionUsers.size());
        for (String userId : this.sessionUsers.values()) {
            sessionUserChannels.put(userId, this.socketUsers.getUserChannels().get(userId));
        }
        output.writeObject(sessionUserChannels);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        APPLICATION_SCOPE.putAll((Map)input.readObject());
        Map sessionUserChannels = (Map)input.readObject();
        for (Map.Entry<Serializable, String> sessionUser : this.sessionUsers.entrySet()) {
            String userId = sessionUser.getValue();
            this.socketUsers.register(sessionUser.getKey(), userId);
            this.socketUsers.getUserChannels().put(userId, (ConcurrentHashMap<String, Set<String>>)sessionUserChannels.get(userId));
        }
        this.socketSessions.register(this.sessionScopedChannels.values());
        this.socketSessions.register(APPLICATION_SCOPE.values());
    }

    @ViewScoped
    protected static class ViewScope
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ConcurrentHashMap<String, String> channels = new ConcurrentHashMap(1);

        protected ViewScope() {
        }

        protected Map<String, String> getChannels() {
            return this.channels;
        }

        @PreDestroy
        protected void deregisterViewScope() {
            SocketSessionManager.getInstance().deregister(this.channels.values());
        }
    }

    private static enum Scope {
        APPLICATION,
        SESSION,
        VIEW;


        static Scope of(String value, Serializable user) {
            if (value == null) {
                return user == null ? APPLICATION : SESSION;
            }
            for (Scope scope : Scope.values()) {
                if (!scope.name().equalsIgnoreCase(value) || user != null && scope == APPLICATION) continue;
                return scope;
            }
            throw new IllegalArgumentException(String.format(SocketChannelManager.ERROR_INVALID_SCOPE, value));
        }
    }
}

