/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.eager;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import org.omnifaces.cdi.Eager;
import org.omnifaces.cdi.ViewScoped;
import org.omnifaces.cdi.eager.EagerBeansRepository;
import org.omnifaces.util.Beans;
import org.omnifaces.util.BeansLocal;

public class EagerExtension
implements Extension {
    private static final Logger logger = Logger.getLogger(EagerExtension.class.getName());
    private static final String ERROR_EAGER_UNAVAILABLE = "@Eager is unavailable. The EagerBeansRepository could not be obtained from CDI bean manager.";
    private EagerBeansRepository.EagerBeans eagerBeans = new EagerBeansRepository.EagerBeans();

    public <T> void collect(@Observes ProcessBean<T> event, BeanManager beanManager) {
        Annotated annotated = event.getAnnotated();
        Eager eager = BeansLocal.getAnnotation(beanManager, annotated, Eager.class);
        if (eager != null) {
            Bean bean = event.getBean();
            if (BeansLocal.getAnnotation(beanManager, annotated, ApplicationScoped.class) != null) {
                this.eagerBeans.addApplicationScoped(bean);
            } else if (BeansLocal.getAnnotation(beanManager, annotated, SessionScoped.class) != null) {
                this.eagerBeans.addSessionScoped(bean);
            } else if (BeansLocal.getAnnotation(beanManager, annotated, javax.faces.view.ViewScoped.class) != null || BeansLocal.getAnnotation(beanManager, annotated, ViewScoped.class) != null) {
                this.eagerBeans.addByViewId(bean, eager.viewId());
            } else if (BeansLocal.getAnnotation(beanManager, annotated, RequestScoped.class) != null) {
                this.eagerBeans.addByRequestURIOrViewId(bean, eager.requestURI(), eager.viewId());
            }
        }
    }

    public void load(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        if (this.eagerBeans.isEmpty()) {
            return;
        }
        EagerBeansRepository eagerBeansRepository = BeansLocal.getReference(beanManager, EagerBeansRepository.class, new Annotation[0]);
        if (eagerBeansRepository == null && (eagerBeansRepository = Beans.getReference(EagerBeansRepository.class, new Annotation[0])) == null) {
            logger.warning(ERROR_EAGER_UNAVAILABLE);
            return;
        }
        eagerBeansRepository.setEagerBeans(this.eagerBeans);
    }
}

