/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.omnifaces.config.OmniFaces;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.util.Platform;

public class ApplicationInitializer
implements ServletContainerInitializer {
    private static final Logger logger = Logger.getLogger(ApplicationInitializer.class.getName());
    static final String WARNING_OMNIFACES_INITIALIZATION_FAIL = "OmniFaces failed to initialize! %s";
    static final String ERROR_OMNIFACES_INITIALIZATION_FAIL = "OmniFaces failed to initialize! Report an issue to OmniFaces.";

    public void onStartup(Set<Class<?>> c, ServletContext servletContext) throws ServletException {
        this.logOmniFacesVersion();
        try {
            Platform.getDefaultFacesServletMapping(servletContext);
            FacesViews.registerForwardingFilter(servletContext);
        }
        catch (Exception | LinkageError e2) {
            if (OmniFaces.skipDeploymentException(servletContext)) {
                logger.log(Level.WARNING, String.format(WARNING_OMNIFACES_INITIALIZATION_FAIL, e2));
            }
            throw new IllegalStateException(ERROR_OMNIFACES_INITIALIZATION_FAIL, e2);
        }
    }

    private void logOmniFacesVersion() {
        logger.info("Using OmniFaces version " + OmniFaces.getVersion());
    }
}

