/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.DefaultsDescriptor;
import org.eclipse.jetty.ee10.webapp.OverrideDescriptor;
import org.eclipse.jetty.ee10.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebDescriptor;
import org.eclipse.jetty.ee10.webapp.WebInfConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebXmlConfiguration.class);

    public WebXmlConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(WebInfConfiguration.class));
    }

    @Override
    public void preConfigure(WebAppContext context2) throws Exception {
        Resource webxml;
        String defaultsDescriptor = context2.getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = context2.getResourceFactory().newClassLoaderResource(defaultsDescriptor);
            if (Resources.missing(dftResource)) {
                URL url;
                String pkg = WebXmlConfiguration.class.getPackageName().replace(".", "/") + "/";
                if (defaultsDescriptor.startsWith(pkg) && (url = WebXmlConfiguration.class.getResource(defaultsDescriptor.substring(pkg.length()))) != null) {
                    URI uri = url.toURI();
                    dftResource = context2.getResourceFactory().newResource(uri);
                }
                if (Resources.missing(dftResource)) {
                    dftResource = context2.newResource(defaultsDescriptor);
                }
            }
            if (Resources.isReadableFile(dftResource)) {
                context2.getMetaData().setDefaultsDescriptor(new DefaultsDescriptor(dftResource));
            }
        }
        if ((webxml = this.findWebXml(context2)) != null) {
            context2.getMetaData().setWebDescriptor(new WebDescriptor(webxml));
            context2.getContext().getServletContext().setEffectiveMajorVersion(context2.getMetaData().getWebDescriptor().getMajorVersion());
            context2.getContext().getServletContext().setEffectiveMinorVersion(context2.getMetaData().getWebDescriptor().getMinorVersion());
        }
        for (String overrideDescriptor : context2.getOverrideDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = context2.getResourceFactory().newClassLoaderResource(overrideDescriptor);
            if (Resources.missing(orideResource)) {
                orideResource = context2.newResource(overrideDescriptor);
            }
            if (!Resources.isReadableFile(orideResource)) continue;
            context2.getMetaData().addOverrideDescriptor(new OverrideDescriptor(orideResource));
        }
    }

    @Override
    public void configure(WebAppContext context2) throws Exception {
        context2.getMetaData().addDescriptorProcessor(new StandardDescriptorProcessor());
    }

    protected Resource findWebXml(WebAppContext context2) throws IOException, MalformedURLException {
        Resource web;
        String descriptor = context2.getDescriptor();
        if (descriptor != null && (web = context2.newResource(descriptor)) != null && !web.isDirectory()) {
            return web;
        }
        Resource webInf = context2.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource web2 = webInf.resolve("web.xml");
            if (Resources.isReadableFile(web2)) {
                return web2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No WEB-INF/web.xml in {}. Serving files and default/dynamic servlets only", (Object)context2.getWar());
            }
        }
        return null;
    }

    @Override
    public void deconfigure(WebAppContext context2) throws Exception {
        context2.setWelcomeFiles(null);
        Request.Handler handler = context2.getErrorHandler();
        if (handler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler errorPageErrorHandler = (ErrorPageErrorHandler)handler;
            errorPageErrorHandler.setErrorPages(null);
        }
    }
}

