/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.MountedPathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebInfConfiguration.class);
    public static final String TEMPORARY_RESOURCE_BASE = "org.eclipse.jetty.webapp.tmpResourceBase";
    public static final String ORIGINAL_RESOURCE_BASE = "org.eclipse.jetty.webapp.originalResourceBase";

    public WebInfConfiguration() {
        this(new AbstractConfiguration.Builder());
    }

    protected WebInfConfiguration(AbstractConfiguration.Builder builder) {
        super(builder);
    }

    @Override
    public void preConfigure(WebAppContext context2) throws Exception {
        this.resolveTempDirectory(context2);
        context2.createTempDirectory();
        this.unpack(context2);
    }

    @Override
    public void configure(WebAppContext context2) throws Exception {
        Resource webInf = context2.getWebInf();
        if (webInf != null && webInf.isDirectory() && context2.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = webInf.resolve("classes/");
            if (Resources.isReadableDirectory(classes)) {
                ((WebAppClassLoader)context2.getClassLoader()).addClassPath(classes);
            }
            if (Resources.isReadableDirectory(lib = webInf.resolve("lib/"))) {
                ((WebAppClassLoader)context2.getClassLoader()).addJars(lib);
            }
        }
    }

    @Override
    public void deconfigure(WebAppContext context2) throws Exception {
        Resource originalBaseResource = (Resource)context2.removeAttribute(ORIGINAL_RESOURCE_BASE);
        context2.setBaseResource(originalBaseResource);
    }

    public void resolveTempDirectory(WebAppContext context2) throws Exception {
        File tempDirectory = context2.getTempDirectory();
        if (tempDirectory != null) {
            return;
        }
        File servletTmpDir = IO.asFile(context2.getAttribute("jakarta.servlet.context.tempdir"));
        if (servletTmpDir != null) {
            tempDirectory = servletTmpDir;
            context2.setTempDirectory(tempDirectory);
            return;
        }
        context2.makeTempDirectory();
    }

    @Deprecated(forRemoval=true, since="12.0.12")
    public void makeTempDirectory(File parent, WebAppContext context2) throws Exception {
        context2.makeTempDirectory();
    }

    public void unpack(WebAppContext context2) throws IOException {
        Resource webApp = context2.getBaseResource();
        context2.setAttribute(ORIGINAL_RESOURCE_BASE, context2.getBaseResource());
        if (webApp == null) {
            Resource jarWebApp;
            String war = context2.getWar();
            webApp = war != null && war.length() > 0 ? context2.newResource(war) : context2.getBaseResource();
            if (webApp == null) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            if (webApp.isAlias()) {
                Resource realWebApp;
                URI realURI = webApp.getRealURI();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} anti-aliased to {}", (Object)webApp, (Object)realURI);
                }
                if (Resources.exists(realWebApp = context2.newResource(realURI))) {
                    webApp = realWebApp;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try webapp={} exists={} directory={} file={}", webApp, webApp.exists(), webApp.isDirectory(), webApp.getPath());
            }
            Resource originalWarResource = webApp;
            if (Resources.isReadableFile(webApp) && FileID.isArchive(webApp.getURI()) && !webApp.getURI().getScheme().equalsIgnoreCase("jar") && Resources.isDirectory(jarWebApp = context2.getResourceFactory().newJarFileResource(webApp.getURI()))) {
                webApp = jarWebApp;
            }
            if (context2.isCopyWebDir() && webApp.getPath() != null && originalWarResource.isDirectory() || context2.isExtractWAR() && webApp.getPath() != null && !originalWarResource.isDirectory() || context2.isExtractWAR() && webApp.getPath() == null || !webApp.isDirectory()) {
                Path sibling;
                Path warPath;
                Path extractedWebAppDir = null;
                if (war != null && (warPath = context2.getResourceFactory().newResource(war).getPath()) != null && FileID.isWebArchive(warPath) && Files.exists(warPath, new LinkOption[0]) && Files.exists(sibling = warPath.getParent().resolve(FileID.getBasename(warPath)), new LinkOption[0]) && Files.isDirectory(sibling, new LinkOption[0]) && Files.isWritable(sibling)) {
                    extractedWebAppDir = sibling;
                }
                if (extractedWebAppDir == null) {
                    extractedWebAppDir = context2.getTempDirectory().toPath().resolve("webapp");
                    context2.setAttribute(TEMPORARY_RESOURCE_BASE, extractedWebAppDir);
                }
                if (Resources.isReadableDirectory(webApp)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copy {} to  {}", (Object)webApp, (Object)extractedWebAppDir);
                    }
                    webApp.copyTo(extractedWebAppDir);
                } else {
                    File extractionLock = new File(context2.getTempDirectory(), ".extract_lock");
                    if (!Files.exists(extractedWebAppDir, new LinkOption[0])) {
                        extractionLock.createNewFile();
                        Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    } else if (originalWarResource.lastModified().isAfter(Files.getLastModifiedTime(extractedWebAppDir, new LinkOption[0]).toInstant()) || extractionLock.exists()) {
                        extractionLock.createNewFile();
                        if (IO.delete(extractedWebAppDir)) {
                            Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        } else if (LOG.isInfoEnabled()) {
                            LOG.info("Unable to delete path {}, reusing existing path", (Object)extractedWebAppDir);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    }
                }
                Resource extractedWebApp = context2.getResourceFactory().newResource(extractedWebAppDir.normalize());
                if (extractedWebApp == null) {
                    LOG.warn("Unable to use non-existent extracted war location: " + String.valueOf(extractedWebApp));
                } else {
                    webApp = extractedWebApp;
                }
            }
            if (Resources.missing(webApp)) {
                LOG.warn("Web application not found {}", (Object)war);
                throw new FileNotFoundException(war);
            }
            context2.setBaseResource(webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("webapp={}", (Object)webApp);
            }
        }
        if (context2.isCopyWebInf() && !context2.isCopyWebDir()) {
            Resource webInf = webApp.resolve("WEB-INF/");
            if (Resources.isReadableDirectory(webInf)) {
                Resource webInfClasses;
                File extractedWebInfDir = new File(context2.getTempDirectory(), "webinf");
                if (extractedWebInfDir.exists()) {
                    IO.delete(extractedWebInfDir);
                }
                extractedWebInfDir.mkdir();
                Resource webInfLib = webInf.resolve("lib/");
                File webInfDir = new File(extractedWebInfDir, "WEB-INF");
                webInfDir.mkdir();
                if (Resources.isReadableDirectory(webInfLib)) {
                    File webInfLibDir = new File(webInfDir, "lib");
                    if (webInfLibDir.exists()) {
                        IO.delete(webInfLibDir);
                    }
                    webInfLibDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/lib {} to {}", (Object)webInfLib, (Object)webInfLibDir);
                    }
                    webInfLib.copyTo(webInfLibDir.toPath());
                }
                if (Resources.isReadableDirectory(webInfClasses = webInf.resolve("classes/"))) {
                    File webInfClassesDir = new File(webInfDir, "classes");
                    if (webInfClassesDir.exists()) {
                        IO.delete(webInfClassesDir);
                    }
                    webInfClassesDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/classes from {} to {}", (Object)webInfClasses, (Object)webInfClassesDir.getAbsolutePath());
                    }
                    webInfClasses.copyTo(webInfClassesDir.toPath());
                }
                webInf = context2.getResourceFactory().newResource(extractedWebInfDir.getCanonicalPath());
            }
            Resource rc = ResourceFactory.combine(webInf, webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("context.baseResource={}", (Object)rc);
            }
            context2.setBaseResource(rc);
        }
    }

    @Deprecated(forRemoval=true, since="12.0.12")
    public static String getCanonicalNameForWebAppTmpDir(WebAppContext context2) {
        return context2.getCanonicalNameForTmpDir();
    }

    @Deprecated(forRemoval=true, since="12.0.12")
    protected static String getResourceBaseName(Resource resource) {
        Path resourceFile = resource.getPath();
        if (resourceFile != null && resource instanceof MountedPathResource) {
            resourceFile = ((MountedPathResource)resource).getContainerPath();
        }
        if (resourceFile != null) {
            Path fileName = resourceFile.getFileName();
            return fileName == null ? "" : fileName.toString();
        }
        URI uri = resource.getURI();
        if (uri == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource has no URI reference: {}", (Object)resource);
            }
            return "";
        }
        return URIUtil.getUriLastPathSegment(uri);
    }
}

